/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.serde.VersionedObjectMapperFactory;
import com.amazonaws.athena.connector.lambda.utils.TestUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Collections;
import org.junit.After;
import org.junit.Before;

public abstract class TypedSerDeTest<T> {
    protected TestUtils utils = new TestUtils();
    protected BlockAllocator allocator;
    protected ObjectMapper mapper;
    protected ObjectMapper mapperV3;
    protected FederatedIdentity federatedIdentity = new FederatedIdentity("testArn", "0123456789", Collections.emptyMap(), Collections.emptyList());
    protected String expectedSerDeText;
    protected T expected;

    @Before
    public void before() {
        this.allocator = new BlockAllocatorImpl("test-allocator-id");
        this.mapper = VersionedObjectMapperFactory.create((BlockAllocator)this.allocator, (int)2);
        this.mapperV3 = VersionedObjectMapperFactory.create((BlockAllocator)this.allocator, (int)3);
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    @After
    public void after() {
        this.allocator.close();
    }

    public abstract void serialize() throws Exception;

    public abstract void deserialize() throws IOException;
}

