/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.SupportedTypes;
import com.amazonaws.athena.connector.lambda.serde.v2.ArrowTypeSerDe;
import com.google.common.collect.ImmutableMap;
import java.util.TreeMap;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.Assert;
import org.junit.Test;

public class ArrowSerDeTest {
    private static final ImmutableMap<SupportedTypes, String> FALL_BACK_ARROW_TYPE_CLASS = ImmutableMap.of((Object)SupportedTypes.TIMESTAMPMILLITZ, (Object)ArrowType.Timestamp.class.getSimpleName());

    @Test
    public void testSupportedTypesHaveSerializers() {
        ArrowTypeSerDe.Serializer arrowTypeSerializer = new ArrowTypeSerDe.Serializer();
        TreeMap delegateSerDeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        delegateSerDeMap.putAll(arrowTypeSerializer.getDelegateSerDeMap());
        for (SupportedTypes supportedType : SupportedTypes.values()) {
            String arrowTypeClass;
            try {
                ArrowType arrowType = supportedType.getArrowMinorType().getType();
                arrowTypeClass = arrowType.getClass().getSimpleName();
            }
            catch (UnsupportedOperationException e) {
                arrowTypeClass = (String)FALL_BACK_ARROW_TYPE_CLASS.getOrDefault((Object)supportedType, (Object)supportedType.name());
            }
            Assert.assertTrue((String)("No serializer for supported type " + supportedType + " with ArrowType " + arrowTypeClass), (boolean)delegateSerDeMap.containsKey(arrowTypeClass));
        }
    }

    @Test
    public void testSupportedTypesHaveDeserializers() {
        ArrowTypeSerDe.Deserializer arrowTypeDeserializer = new ArrowTypeSerDe.Deserializer();
        TreeMap delegateSerDeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        delegateSerDeMap.putAll(arrowTypeDeserializer.getDelegateSerDeMap());
        for (SupportedTypes supportedType : SupportedTypes.values()) {
            String arrowTypeClass;
            try {
                ArrowType arrowType = supportedType.getArrowMinorType().getType();
                arrowTypeClass = arrowType.getClass().getSimpleName();
            }
            catch (UnsupportedOperationException e) {
                arrowTypeClass = (String)FALL_BACK_ARROW_TYPE_CLASS.getOrDefault((Object)supportedType, (Object)supportedType.name());
            }
            Assert.assertTrue((String)("No deserializer for supported type " + supportedType + " with ArrowType " + arrowTypeClass), (boolean)delegateSerDeMap.containsKey(arrowTypeClass));
        }
    }
}

