/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.GetTableResponse;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedSerDeTest;
import com.fasterxml.jackson.core.JsonEncoding;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTableResponseSerDeTest
extends TypedSerDeTest<FederationResponse> {
    private static final Logger logger = LoggerFactory.getLogger(GetTableResponseSerDeTest.class);

    @Before
    public void beforeTest() throws IOException {
        Schema schema = SchemaBuilder.newBuilder().addField("year", (ArrowType)new ArrowType.Int(32, true)).addField("month", (ArrowType)new ArrowType.Int(32, true)).addField("day", (ArrowType)new ArrowType.Int(32, true)).addField("col3", (ArrowType)new ArrowType.Utf8()).build();
        this.expected = new GetTableResponse("test-catalog", new TableName("test-schema", "test-table"), schema, (Set)ImmutableSet.of((Object)"year", (Object)"month", (Object)"day"));
        String expectedSerDeFile = this.utils.getResourceOrFail("serde/v2", "GetTableResponse.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
    }

    @Override
    @Test
    public void serialize() throws IOException {
        logger.info("serialize: enter");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)outputStream, this.expected);
        String actual = new String(outputStream.toByteArray(), JsonEncoding.UTF8.getJavaName());
        logger.info("serialize: serialized text[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expectedSerDeText, (Object)actual);
        logger.info("serialize: exit");
    }

    @Override
    @Test
    public void deserialize() throws IOException {
        logger.info("deserialize: enter");
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        GetTableResponse actual = (GetTableResponse)this.mapper.readValue((InputStream)input, FederationResponse.class);
        logger.info("deserialize: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        logger.info("deserialize: exit");
    }
}

