/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.DateTimeFormatterUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.bouncycastle.util.Arrays;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowTypeComparator {
    private static final Logger logger = LoggerFactory.getLogger(ArrowTypeComparator.class);

    private ArrowTypeComparator() {
    }

    public static int compare(FieldReader reader, Object lhs, Object rhs) {
        return ArrowTypeComparator.compare(reader.getField().getType(), lhs, rhs);
    }

    public static int compare(ArrowType arrowType, Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null) {
            return 1;
        }
        if (rhs == null) {
            return -1;
        }
        Types.MinorType type = Types.getMinorTypeForArrowType((ArrowType)arrowType);
        switch (type) {
            case INT: 
            case UINT4: {
                return Integer.compare((Integer)lhs, (Integer)rhs);
            }
            case TINYINT: 
            case UINT1: {
                return Byte.compare((Byte)lhs, (Byte)rhs);
            }
            case SMALLINT: {
                return Short.compare((Short)lhs, (Short)rhs);
            }
            case UINT2: {
                return Character.compare(((Character)lhs).charValue(), ((Character)rhs).charValue());
            }
            case BIGINT: 
            case UINT8: {
                return Long.compare((Long)lhs, (Long)rhs);
            }
            case FLOAT8: {
                return Double.compare((Double)lhs, (Double)rhs);
            }
            case FLOAT4: {
                return Float.compare(((Float)lhs).floatValue(), ((Float)rhs).floatValue());
            }
            case VARCHAR: {
                return lhs.toString().compareTo(rhs.toString());
            }
            case VARBINARY: {
                return Arrays.compareUnsigned((byte[])((byte[])lhs), (byte[])((byte[])rhs));
            }
            case DECIMAL: {
                return ((BigDecimal)lhs).compareTo((BigDecimal)rhs);
            }
            case BIT: {
                return Boolean.compare((Boolean)lhs, (Boolean)rhs);
            }
            case DATEMILLI: {
                return ((LocalDateTime)lhs).compareTo((LocalDateTime)rhs);
            }
            case DATEDAY: {
                return ((Integer)lhs).compareTo((Integer)rhs);
            }
            case TIMESTAMPMILLITZ: {
                if (lhs instanceof Long) {
                    ZonedDateTime lhsZdt = DateTimeFormatterUtil.constructZonedDateTime((Long)lhs);
                    ZonedDateTime rhsZdt = DateTimeFormatterUtil.constructZonedDateTime((Long)rhs);
                    return lhsZdt.compareTo(rhsZdt);
                }
                if (lhs instanceof org.joda.time.LocalDateTime) {
                    ZonedDateTime lhsZdt = ArrowTypeComparator.getZonedDateTime((org.joda.time.LocalDateTime)lhs);
                    ZonedDateTime rhsZdt = ArrowTypeComparator.getZonedDateTime((org.joda.time.LocalDateTime)rhs);
                    return lhsZdt.compareTo(rhsZdt);
                }
                return ((LocalDateTime)lhs).compareTo((LocalDateTime)rhs);
            }
            case MAP: 
            case LIST: 
            case STRUCT: {
                if (lhs.equals(rhs)) {
                    return 0;
                }
                if (lhs.hashCode() < rhs.hashCode()) {
                    return -1;
                }
                return 1;
            }
        }
        logger.warn("compare: Unknown type " + type + " object: " + lhs.getClass());
        throw new IllegalArgumentException("Unknown type " + type + " object: " + lhs.getClass());
    }

    private static ZonedDateTime getZonedDateTime(org.joda.time.LocalDateTime ldt) {
        DateTimeZone dtz = ldt.getChronology().getZone();
        long dateTimeWithTimeZone = ldt.toDateTime(dtz).getMillis();
        return DateTimeFormatterUtil.constructZonedDateTime(dateTimeWithTimeZone);
    }
}

