/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.DateTimeFormatterUtil;
import com.amazonaws.athena.connector.lambda.data.FieldResolver;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.BitWriter;
import org.apache.arrow.vector.complex.writer.DateDayWriter;
import org.apache.arrow.vector.complex.writer.DateMilliWriter;
import org.apache.arrow.vector.complex.writer.DecimalWriter;
import org.apache.arrow.vector.complex.writer.FieldWriter;
import org.apache.arrow.vector.complex.writer.Float4Writer;
import org.apache.arrow.vector.complex.writer.Float8Writer;
import org.apache.arrow.vector.complex.writer.IntWriter;
import org.apache.arrow.vector.complex.writer.SmallIntWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMilliTZWriter;
import org.apache.arrow.vector.complex.writer.TinyIntWriter;
import org.apache.arrow.vector.complex.writer.UInt1Writer;
import org.apache.arrow.vector.complex.writer.UInt2Writer;
import org.apache.arrow.vector.complex.writer.UInt4Writer;
import org.apache.arrow.vector.complex.writer.UInt8Writer;
import org.apache.arrow.vector.complex.writer.VarBinaryWriter;
import org.apache.arrow.vector.complex.writer.VarCharWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.apache.commons.codec.Charsets;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDateTime;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;

public class BlockUtils {
    public static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    public static final MutableDateTime EPOCH = new MutableDateTime();
    private static final char[] HEX_ARRAY;

    public static Block newBlock(BlockAllocator allocator, String columnName, ArrowType type, Object ... values) {
        return BlockUtils.newBlock(allocator, columnName, type, Arrays.asList(values));
    }

    public static Block newBlock(BlockAllocator allocator, String columnName, ArrowType type, Collection<Object> values) {
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addField(columnName, type);
        Schema schema = schemaBuilder.build();
        Block block = allocator.createBlock(schema);
        int count = 0;
        for (Object next : values) {
            try {
                BlockUtils.setValue(block.getFieldVector(columnName), count++, next);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error for " + type + " " + columnName + " " + next, ex);
            }
        }
        block.setRowCount(count);
        return block;
    }

    public static Block newEmptyBlock(BlockAllocator allocator, String columnName, ArrowType type) {
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addField(columnName, type);
        Schema schema = schemaBuilder.build();
        return allocator.createBlock(schema);
    }

    public static void setComplexValue(FieldVector vector, int pos, FieldResolver resolver, Object value) {
        if (vector instanceof MapVector) {
            UnionMapWriter writer = ((MapVector)vector).getWriter();
            writer.setPosition(pos);
            BlockUtils.writeMap(vector.getAllocator(), (BaseWriter.MapWriter)writer, vector.getField(), pos, value, resolver);
        } else if (vector instanceof ListVector) {
            UnionListWriter writer = ((ListVector)vector).getWriter();
            writer.setPosition(pos);
            BlockUtils.writeList(vector.getAllocator(), (FieldWriter)writer, vector.getField(), pos, (List)value, resolver);
        } else if (vector instanceof StructVector) {
            NullableStructWriter writer = ((StructVector)vector).getWriter();
            writer.setPosition(pos);
            BlockUtils.writeStruct(vector.getAllocator(), (BaseWriter.StructWriter)writer, vector.getField(), pos, value, resolver);
        } else {
            throw new RuntimeException("Unsupported 'Complex' vector " + vector.getClass().getSimpleName() + " for field " + vector.getField().getName());
        }
    }

    public static void setValue(FieldVector vector, int pos, Object value) {
        try {
            if (value == null) {
                BlockUtils.setNullValue(vector, pos);
                return;
            }
            switch (vector.getMinorType()) {
                case TIMESTAMPMILLITZ: {
                    if (value instanceof LocalDateTime) {
                        DateTimeZone dtz = ((LocalDateTime)value).getChronology().getZone();
                        long dateTimeWithZone = ((LocalDateTime)value).toDateTime(dtz).getMillis();
                        ((TimeStampMilliTZVector)vector).setSafe(pos, dateTimeWithZone);
                    }
                    if (value instanceof ZonedDateTime) {
                        long dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone((ZonedDateTime)value);
                        ((TimeStampMilliTZVector)vector).setSafe(pos, dateTimeWithZone);
                        break;
                    }
                    if (value instanceof java.time.LocalDateTime) {
                        long dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone(((java.time.LocalDateTime)value).atZone(UTC_ZONE_ID).toInstant().toEpochMilli(), UTC_ZONE_ID.getId());
                        ((TimeStampMilliTZVector)vector).setSafe(pos, dateTimeWithZone);
                        break;
                    }
                    if (value instanceof Date) {
                        long ldtInLong = Instant.ofEpochMilli(((Date)value).getTime()).atZone(UTC_ZONE_ID).toInstant().toEpochMilli();
                        long dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone(ldtInLong, UTC_ZONE_ID.getId());
                        ((TimeStampMilliTZVector)vector).setSafe(pos, dateTimeWithZone);
                        break;
                    }
                    ((TimeStampMilliTZVector)vector).setSafe(pos, ((Long)value).longValue());
                    break;
                }
                case DATEMILLI: {
                    if (value instanceof Date) {
                        ((DateMilliVector)vector).setSafe(pos, ((Date)value).getTime());
                        break;
                    }
                    if (value instanceof java.time.LocalDateTime) {
                        ((DateMilliVector)vector).setSafe(pos, ((java.time.LocalDateTime)value).atZone(UTC_ZONE_ID).toInstant().toEpochMilli());
                        break;
                    }
                    ((DateMilliVector)vector).setSafe(pos, ((Long)value).longValue());
                    break;
                }
                case DATEDAY: {
                    if (value instanceof Date) {
                        Days days = Days.daysBetween((ReadableInstant)EPOCH, (ReadableInstant)new DateTime(((Date)value).getTime()));
                        ((DateDayVector)vector).setSafe(pos, days.getDays());
                        break;
                    }
                    if (value instanceof LocalDate) {
                        int days = (int)((LocalDate)value).toEpochDay();
                        ((DateDayVector)vector).setSafe(pos, days);
                        break;
                    }
                    if (value instanceof Long) {
                        ((DateDayVector)vector).setSafe(pos, ((Long)value).intValue());
                        break;
                    }
                    ((DateDayVector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case FLOAT8: {
                    ((Float8Vector)vector).setSafe(pos, ((Double)value).doubleValue());
                    break;
                }
                case FLOAT4: {
                    ((Float4Vector)vector).setSafe(pos, ((Float)value).floatValue());
                    break;
                }
                case INT: {
                    if (value != null && value instanceof Long) {
                        ((IntVector)vector).setSafe(pos, ((Long)value).intValue());
                        break;
                    }
                    ((IntVector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case TINYINT: {
                    if (value instanceof Byte) {
                        ((TinyIntVector)vector).setSafe(pos, ((Byte)value).byteValue());
                        break;
                    }
                    ((TinyIntVector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case SMALLINT: {
                    if (value instanceof Short) {
                        ((SmallIntVector)vector).setSafe(pos, ((Short)value).shortValue());
                        break;
                    }
                    ((SmallIntVector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case UINT1: {
                    if (value instanceof Byte) {
                        ((UInt1Vector)vector).setSafe(pos, ((Byte)value).byteValue());
                        break;
                    }
                    ((UInt1Vector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case UINT2: {
                    if (value instanceof Character) {
                        ((UInt2Vector)vector).setSafe(pos, ((Character)value).charValue());
                        break;
                    }
                    ((UInt2Vector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case UINT4: {
                    ((UInt4Vector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case UINT8: {
                    if (value instanceof Long) {
                        ((UInt8Vector)vector).setSafe(pos, ((Long)value).longValue());
                        break;
                    }
                    ((UInt8Vector)vector).setSafe(pos, (long)((Integer)value).intValue());
                    break;
                }
                case BIGINT: {
                    ((BigIntVector)vector).setSafe(pos, ((Long)value).longValue());
                    break;
                }
                case VARBINARY: {
                    ((VarBinaryVector)vector).setSafe(pos, (byte[])value);
                    break;
                }
                case DECIMAL: {
                    DecimalVector dVector = (DecimalVector)vector;
                    if (value instanceof Double) {
                        BigDecimal bdVal = new BigDecimal((Double)value);
                        bdVal = bdVal.setScale(dVector.getScale(), RoundingMode.HALF_UP);
                        dVector.setSafe(pos, bdVal);
                        break;
                    }
                    BigDecimal scaledValue = ((BigDecimal)value).setScale(dVector.getScale(), RoundingMode.HALF_UP);
                    ((DecimalVector)vector).setSafe(pos, scaledValue);
                    break;
                }
                case VARCHAR: {
                    if (value instanceof Text) {
                        ((VarCharVector)vector).setSafe(pos, (Text)value);
                        break;
                    }
                    ((VarCharVector)vector).setSafe(pos, value.toString().getBytes(Charsets.UTF_8));
                    break;
                }
                case BIT: {
                    if (value instanceof Integer && (Integer)value > 0) {
                        ((BitVector)vector).setSafe(pos, 1);
                        break;
                    }
                    if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                        ((BitVector)vector).setSafe(pos, 1);
                        break;
                    }
                    ((BitVector)vector).setSafe(pos, 0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + vector.getMinorType());
                }
            }
        }
        catch (RuntimeException ex) {
            String fieldName = vector != null ? vector.getField().getName() : "null_vector";
            throw new RuntimeException("Unable to set value for field " + fieldName + " using value " + value + " of type " + vector.getMinorType(), ex);
        }
    }

    public static String rowToString(Block block, int row) {
        if (row > block.getRowCount()) {
            throw new IllegalArgumentException(row + " exceeds available rows " + block.getRowCount());
        }
        StringBuilder sb = new StringBuilder();
        for (FieldReader nextReader : block.getFieldReaders()) {
            try {
                nextReader.setPosition(row);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("[");
                sb.append(nextReader.getField().getName());
                sb.append(" : ");
                sb.append(BlockUtils.fieldToString(nextReader));
                sb.append("]");
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("Error processing field " + nextReader.getField().getName(), ex);
            }
        }
        return sb.toString();
    }

    public static String fieldToString(FieldReader reader) {
        switch (reader.getMinorType()) {
            case DATEDAY: {
                return String.valueOf(reader.readInteger());
            }
            case TIMESTAMPMILLITZ: {
                return String.valueOf(DateTimeFormatterUtil.constructZonedDateTime(reader.readLong()));
            }
            case DATEMILLI: {
                return String.valueOf(reader.readLocalDateTime());
            }
            case FLOAT8: 
            case FLOAT4: 
            case INT: 
            case UINT4: 
            case UINT8: 
            case BIGINT: 
            case VARCHAR: 
            case BIT: {
                return String.valueOf(reader.readObject());
            }
            case DECIMAL: {
                return String.valueOf(reader.readBigDecimal());
            }
            case SMALLINT: {
                return String.valueOf(reader.readShort());
            }
            case TINYINT: 
            case UINT1: {
                return Integer.valueOf(reader.readByte().byteValue()).toString();
            }
            case UINT2: {
                return Integer.valueOf(reader.readCharacter().charValue()).toString();
            }
            case VARBINARY: {
                return BlockUtils.bytesToHex(reader.readByteArray());
            }
            case STRUCT: {
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                for (Field child : reader.getField().getChildren()) {
                    if (sb.length() > 3) {
                        sb.append(",");
                    }
                    sb.append("[");
                    sb.append(child.getName());
                    sb.append(" : ");
                    sb.append(BlockUtils.fieldToString(reader.reader(child.getName())));
                    sb.append("]");
                }
                sb.append("}");
                return sb.toString();
            }
            case LIST: {
                StringBuilder sbList = new StringBuilder();
                sbList.append("{");
                while (reader.next()) {
                    if (sbList.length() > 1) {
                        sbList.append(",");
                    }
                    sbList.append(BlockUtils.fieldToString(reader.reader()));
                }
                sbList.append("}");
                return sbList.toString();
            }
            case MAP: {
                StringBuilder sbMap = new StringBuilder();
                while (reader.next()) {
                    sbMap.append(BlockUtils.fieldToString(reader.reader()));
                }
                return sbMap.toString();
            }
        }
        Object obj = reader.readObject();
        return reader.getMinorType() + " - " + (obj != null ? obj.getClass().toString() : "null") + "[ " + String.valueOf(obj) + " ]";
    }

    public static int copyRows(Block srcBlock, Block dstBlock, int firstRow, int lastRow) {
        if (firstRow > lastRow || lastRow > srcBlock.getRowCount() - 1) {
            throw new RuntimeException("src has " + srcBlock.getRowCount() + " but requested copy of " + firstRow + " to " + lastRow);
        }
        for (FieldReader src : srcBlock.getFieldReaders()) {
            int dstOffset = dstBlock.getRowCount();
            for (int i = firstRow; i <= lastRow; ++i) {
                FieldVector dst = dstBlock.getFieldVector(src.getField().getName());
                src.setPosition(i);
                BlockUtils.setValue(dst, dstOffset++, src.readObject());
            }
        }
        int rowsCopied = 1 + (lastRow - firstRow);
        dstBlock.setRowCount(dstBlock.getRowCount() + rowsCopied);
        return rowsCopied;
    }

    public static boolean isNullRow(Block block, int row) {
        if (row > block.getRowCount() - 1) {
            throw new RuntimeException("block has " + block.getRowCount() + " rows but requested to check " + row);
        }
        for (FieldReader src : block.getFieldReaders()) {
            src.setPosition(row);
            if (!src.isSet()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    protected static void writeList(BufferAllocator allocator, FieldWriter writer, Field field, int pos, Iterable value, FieldResolver resolver) {
        if (value == null) {
            writer.writeNull();
            return;
        }
        Field child = null;
        if (field.getChildren() != null && !field.getChildren().isEmpty()) {
            child = (Field)field.getChildren().get(0);
        }
        writer.startList();
        for (Object val : value) {
            BlockUtils.writeAllValue(writer, child, allocator, pos, resolver, val, false);
        }
        writer.endList();
    }

    @VisibleForTesting
    protected static void writeStruct(BufferAllocator allocator, BaseWriter.StructWriter writer, Field field, int pos, Object value, FieldResolver resolver) {
        if (value == null) {
            writer.writeNull();
            return;
        }
        writer.start();
        for (Field nextChild : field.getChildren()) {
            Object childValue = resolver.getFieldValue(nextChild, value);
            BlockUtils.writeAllValue((FieldWriter)writer, nextChild, allocator, pos, resolver, childValue, true);
        }
        writer.end();
    }

    @VisibleForTesting
    protected static void writeMap(BufferAllocator allocator, BaseWriter.MapWriter writer, Field field, int pos, Object value, FieldResolver resolver) {
        if (value == null) {
            writer.writeNull();
            return;
        }
        List children = field.getChildren();
        if (children.size() != 1) {
            throw new IllegalStateException("Invalid Arrow Map schema: " + field);
        }
        Field keyValueStructField = (Field)children.get(0);
        if (!"entries".equals(keyValueStructField.getName()) || !(keyValueStructField.getType() instanceof ArrowType.Struct)) {
            throw new IllegalStateException("Invalid Arrow Map schema: " + field);
        }
        List keyValueChildren = keyValueStructField.getChildren();
        if (keyValueChildren.size() != 2) {
            throw new IllegalStateException("Invalid Arrow Map schema: " + field);
        }
        Field keyField = (Field)keyValueChildren.get(0);
        Field valueField = (Field)keyValueChildren.get(1);
        if (!"key".equals(keyField.getName()) || !"value".equals(valueField.getName())) {
            throw new IllegalStateException("Invalid Arrow Map schema: " + field);
        }
        if (!(value instanceof Map)) {
            value = resolver.getFieldValue(field, value);
        }
        writer.startMap();
        ((Map)value).entrySet().forEach(entry -> {
            writer.startEntry();
            Object entryKeyValue = entry.getKey();
            if (Types.getMinorTypeForArrowType((ArrowType)keyField.getType()) != Types.MinorType.STRUCT) {
                entryKeyValue = resolver.getMapKey(keyField, entry.getKey());
            }
            BlockUtils.writeAllValue((FieldWriter)writer.key(), keyField, allocator, pos, resolver, entryKeyValue, true);
            Object entryValValue = entry.getValue();
            if (entryValValue != null) {
                if (Types.getMinorTypeForArrowType((ArrowType)valueField.getType()) != Types.MinorType.STRUCT) {
                    entryValValue = resolver.getMapValue(valueField, entryValValue);
                }
                BlockUtils.writeAllValue((FieldWriter)writer.value(), valueField, allocator, pos, resolver, entryValValue, true);
            }
            writer.endEntry();
        });
        writer.endMap();
    }

    protected static void writeAllValue(FieldWriter writer, Field field, BufferAllocator allocator, int pos, FieldResolver resolver, Object value, boolean fromMapOrStruct) {
        switch (Types.getMinorTypeForArrowType((ArrowType)field.getType())) {
            case LIST: {
                FieldWriter listFieldWriter = (FieldWriter)(fromMapOrStruct ? writer.list(field.getName()) : writer.list());
                BlockUtils.writeList(allocator, listFieldWriter, field, pos, (List)value, resolver);
                break;
            }
            case STRUCT: {
                FieldWriter structFieldWriter = (FieldWriter)(fromMapOrStruct ? writer.struct(field.getName()) : writer.struct());
                BlockUtils.writeStruct(allocator, (BaseWriter.StructWriter)structFieldWriter, field, pos, value, resolver);
                break;
            }
            case MAP: {
                FieldWriter mapFieldWriter = (FieldWriter)(fromMapOrStruct ? writer.map(field.getName()) : writer.map());
                BlockUtils.writeMap(allocator, (BaseWriter.MapWriter)mapFieldWriter, field, pos, value, resolver);
                break;
            }
            default: {
                BlockUtils.writeSimpleValue(writer, field, allocator, value, fromMapOrStruct);
            }
        }
    }

    protected static void writeSimpleValue(FieldWriter writer, Field field, BufferAllocator allocator, Object value, boolean fromMapOrStruct) {
        ArrowType type = field.getType();
        try {
            switch (Types.getMinorTypeForArrowType((ArrowType)type)) {
                case TIMESTAMPMILLITZ: {
                    long dateTimeWithZone;
                    TimeStampMilliTZWriter timeStampMilliTZWriter;
                    String timezone = ((ArrowType.Timestamp)type).getTimezone();
                    TimeStampMilliTZWriter timeStampMilliTZWriter2 = timeStampMilliTZWriter = fromMapOrStruct ? writer.timeStampMilliTZ(field.getName(), timezone) : writer.timeStampMilliTZ();
                    if (value == null) {
                        timeStampMilliTZWriter.writeNull();
                        break;
                    }
                    if (value instanceof ZonedDateTime) {
                        dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone((ZonedDateTime)value);
                    } else if (value instanceof java.time.LocalDateTime) {
                        dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone(((java.time.LocalDateTime)value).atZone(UTC_ZONE_ID).toInstant().toEpochMilli(), UTC_ZONE_ID.getId());
                    } else if (value instanceof Date) {
                        long ldtInLong = Instant.ofEpochMilli(((Date)value).getTime()).atZone(UTC_ZONE_ID).toInstant().toEpochMilli();
                        dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone(ldtInLong, UTC_ZONE_ID.getId());
                    } else {
                        dateTimeWithZone = (Long)value;
                    }
                    timeStampMilliTZWriter.writeTimeStampMilliTZ(dateTimeWithZone);
                    break;
                }
                case DATEMILLI: {
                    DateMilliWriter dateMilliWriter;
                    DateMilliWriter dateMilliWriter2 = dateMilliWriter = fromMapOrStruct ? writer.dateMilli(field.getName()) : writer.dateMilli();
                    if (value == null) {
                        dateMilliWriter.writeNull();
                        break;
                    }
                    if (value instanceof Date) {
                        dateMilliWriter.writeDateMilli(((Date)value).getTime());
                        break;
                    }
                    if (value instanceof java.time.LocalDateTime) {
                        dateMilliWriter.writeDateMilli(((java.time.LocalDateTime)value).atZone(UTC_ZONE_ID).toInstant().toEpochMilli());
                        break;
                    }
                    dateMilliWriter.writeDateMilli(((Long)value).longValue());
                    break;
                }
                case DATEDAY: {
                    DateDayWriter dateDayWriter;
                    DateDayWriter dateDayWriter2 = dateDayWriter = fromMapOrStruct ? writer.dateDay(field.getName()) : writer.dateDay();
                    if (value == null) {
                        dateDayWriter.writeNull();
                        break;
                    }
                    if (value instanceof Date) {
                        Days days = Days.daysBetween((ReadableInstant)EPOCH, (ReadableInstant)new DateTime(((Date)value).getTime()));
                        dateDayWriter.writeDateDay(days.getDays());
                        break;
                    }
                    if (value instanceof LocalDate) {
                        int days = (int)((LocalDate)value).toEpochDay();
                        dateDayWriter.writeDateDay(days);
                        break;
                    }
                    if (value instanceof Long) {
                        dateDayWriter.writeDateDay(((Long)value).intValue());
                        break;
                    }
                    dateDayWriter.writeDateDay(((Integer)value).intValue());
                    break;
                }
                case FLOAT8: {
                    Float8Writer float8Writer;
                    Float8Writer float8Writer2 = float8Writer = fromMapOrStruct ? writer.float8(field.getName()) : writer.float8();
                    if (value == null) {
                        float8Writer.writeNull();
                        break;
                    }
                    if (value instanceof Integer) {
                        float8Writer.writeFloat8((double)((Integer)value).intValue());
                        break;
                    }
                    float8Writer.writeFloat8(((Double)value).doubleValue());
                    break;
                }
                case FLOAT4: {
                    Float4Writer float4Writer;
                    Float4Writer float4Writer2 = float4Writer = fromMapOrStruct ? writer.float4(field.getName()) : writer.float4();
                    if (value == null) {
                        float4Writer.writeNull();
                        break;
                    }
                    float4Writer.writeFloat4(((Float)value).floatValue());
                    break;
                }
                case INT: {
                    IntWriter integerWriter;
                    IntWriter intWriter = integerWriter = fromMapOrStruct ? writer.integer(field.getName()) : writer.integer();
                    if (value == null) {
                        integerWriter.writeNull();
                        break;
                    }
                    if (value != null && value instanceof Long) {
                        integerWriter.writeInt(((Long)value).intValue());
                        break;
                    }
                    integerWriter.writeInt(((Integer)value).intValue());
                    break;
                }
                case TINYINT: {
                    TinyIntWriter tinyIntWriter;
                    TinyIntWriter tinyIntWriter2 = tinyIntWriter = fromMapOrStruct ? writer.tinyInt(field.getName()) : writer.tinyInt();
                    if (value == null) {
                        tinyIntWriter.writeNull();
                        break;
                    }
                    tinyIntWriter.writeTinyInt(((Byte)value).byteValue());
                    break;
                }
                case SMALLINT: {
                    SmallIntWriter smallIntWriter;
                    SmallIntWriter smallIntWriter2 = smallIntWriter = fromMapOrStruct ? writer.smallInt(field.getName()) : writer.smallInt();
                    if (value == null) {
                        smallIntWriter.writeNull();
                        break;
                    }
                    smallIntWriter.writeSmallInt(((Short)value).shortValue());
                    break;
                }
                case UINT1: {
                    UInt1Writer uInt1Writer;
                    UInt1Writer uInt1Writer2 = uInt1Writer = fromMapOrStruct ? writer.uInt1(field.getName()) : writer.uInt1();
                    if (value == null) {
                        uInt1Writer.writeNull();
                        break;
                    }
                    uInt1Writer.writeUInt1(((Byte)value).byteValue());
                    break;
                }
                case UINT2: {
                    UInt2Writer uInt2Writer;
                    UInt2Writer uInt2Writer2 = uInt2Writer = fromMapOrStruct ? writer.uInt2(field.getName()) : writer.uInt2();
                    if (value == null) {
                        uInt2Writer.writeNull();
                        break;
                    }
                    uInt2Writer.writeUInt2(((Character)value).charValue());
                    break;
                }
                case UINT4: {
                    UInt4Writer uInt4Writer;
                    UInt4Writer uInt4Writer2 = uInt4Writer = fromMapOrStruct ? writer.uInt4(field.getName()) : writer.uInt4();
                    if (value == null) {
                        uInt4Writer.writeNull();
                        break;
                    }
                    uInt4Writer.writeUInt4(((Integer)value).intValue());
                    break;
                }
                case UINT8: {
                    UInt8Writer uInt8Writer;
                    UInt8Writer uInt8Writer2 = uInt8Writer = fromMapOrStruct ? writer.uInt8(field.getName()) : writer.uInt8();
                    if (value == null) {
                        uInt8Writer.writeNull();
                        break;
                    }
                    uInt8Writer.writeUInt8(((Long)value).longValue());
                    break;
                }
                case BIGINT: {
                    BigIntWriter bigIntWriter;
                    BigIntWriter bigIntWriter2 = bigIntWriter = fromMapOrStruct ? writer.bigInt(field.getName()) : writer.bigInt();
                    if (value == null) {
                        bigIntWriter.writeNull();
                        break;
                    }
                    bigIntWriter.writeBigInt(((Long)value).longValue());
                    break;
                }
                case VARBINARY: {
                    VarBinaryWriter varBinaryWriter;
                    VarBinaryWriter varBinaryWriter2 = varBinaryWriter = fromMapOrStruct ? writer.varBinary(field.getName()) : writer.varBinary();
                    if (value == null) {
                        varBinaryWriter.writeNull();
                        break;
                    }
                    if (value instanceof ArrowBuf) {
                        ArrowBuf buf = (ArrowBuf)value;
                        varBinaryWriter.writeVarBinary(0, (int)buf.capacity(), buf);
                        break;
                    }
                    if (!(value instanceof byte[])) break;
                    byte[] bytes = (byte[])value;
                    try (ArrowBuf buf = allocator.buffer((long)bytes.length);){
                        buf.writeBytes(bytes);
                        varBinaryWriter.writeVarBinary(0, (int)buf.readableBytes(), buf);
                        break;
                    }
                }
                case DECIMAL: {
                    DecimalWriter decimalWriter;
                    int scale = ((ArrowType.Decimal)type).getScale();
                    int precision = ((ArrowType.Decimal)type).getPrecision();
                    DecimalWriter decimalWriter2 = decimalWriter = fromMapOrStruct ? writer.decimal(field.getName(), scale, precision) : writer.decimal();
                    if (value == null) {
                        decimalWriter.writeNull();
                        break;
                    }
                    if (value instanceof Double) {
                        BigDecimal bdVal = new BigDecimal((Double)value);
                        bdVal = bdVal.setScale(scale, RoundingMode.HALF_UP);
                        decimalWriter.writeDecimal(bdVal);
                        break;
                    }
                    BigDecimal scaledValue = ((BigDecimal)value).setScale(scale, RoundingMode.HALF_UP);
                    decimalWriter.writeDecimal(scaledValue);
                    break;
                }
                case VARCHAR: {
                    VarCharWriter varCharWriter;
                    VarCharWriter varCharWriter2 = varCharWriter = fromMapOrStruct ? writer.varChar(field.getName()) : writer.varChar();
                    if (value == null) {
                        varCharWriter.writeNull();
                        break;
                    }
                    if (value instanceof String || value instanceof Text) {
                        if (value instanceof Text) {
                            value = ((Text)value).toString();
                        }
                        byte[] bytes = ((String)value).getBytes(Charsets.UTF_8);
                        try (ArrowBuf buf = allocator.buffer((long)bytes.length);){
                            buf.writeBytes(bytes);
                            varCharWriter.writeVarChar(0, (int)buf.readableBytes(), buf);
                            break;
                        }
                    }
                    if (value instanceof ArrowBuf) {
                        ArrowBuf buf = (ArrowBuf)value;
                        varCharWriter.writeVarChar(0, (int)buf.readableBytes(), buf);
                        break;
                    }
                    if (!(value instanceof byte[])) break;
                    byte[] bytes = (byte[])value;
                    try (ArrowBuf buf = allocator.buffer((long)bytes.length);){
                        buf.writeBytes(bytes);
                        varCharWriter.writeVarChar(0, (int)buf.readableBytes(), buf);
                        break;
                    }
                }
                case BIT: {
                    BitWriter bitWriter;
                    BitWriter bitWriter2 = bitWriter = fromMapOrStruct ? writer.bit(field.getName()) : writer.bit();
                    if (value == null) {
                        bitWriter.writeNull();
                        break;
                    }
                    if (value instanceof Integer && (Integer)value > 0) {
                        bitWriter.writeBit(1);
                        break;
                    }
                    if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                        bitWriter.writeBit(1);
                        break;
                    }
                    bitWriter.writeBit(0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + type);
                }
            }
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Unable to write value for field " + field.getName() + " using value " + value + " with minor type " + Types.getMinorTypeForArrowType((ArrowType)type), ex);
        }
    }

    private static void setNullValue(FieldVector vector, int pos) {
        switch (vector.getMinorType()) {
            case TIMESTAMPMILLITZ: {
                ((TimeStampMilliTZVector)vector).setNull(pos);
                break;
            }
            case DATEMILLI: {
                ((DateMilliVector)vector).setNull(pos);
                break;
            }
            case DATEDAY: {
                ((DateDayVector)vector).setNull(pos);
                break;
            }
            case FLOAT8: {
                ((Float8Vector)vector).setNull(pos);
                break;
            }
            case FLOAT4: {
                ((Float4Vector)vector).setNull(pos);
                break;
            }
            case INT: {
                ((IntVector)vector).setNull(pos);
                break;
            }
            case TINYINT: {
                ((TinyIntVector)vector).setNull(pos);
                break;
            }
            case SMALLINT: {
                ((SmallIntVector)vector).setNull(pos);
                break;
            }
            case UINT1: {
                ((UInt1Vector)vector).setNull(pos);
                break;
            }
            case UINT2: {
                ((UInt2Vector)vector).setNull(pos);
                break;
            }
            case UINT4: {
                ((UInt4Vector)vector).setNull(pos);
                break;
            }
            case UINT8: {
                ((UInt8Vector)vector).setNull(pos);
                break;
            }
            case BIGINT: {
                ((BigIntVector)vector).setNull(pos);
                break;
            }
            case VARBINARY: {
                ((VarBinaryVector)vector).setNull(pos);
                break;
            }
            case DECIMAL: {
                ((DecimalVector)vector).setNull(pos);
                break;
            }
            case VARCHAR: {
                ((VarCharVector)vector).setNull(pos);
                break;
            }
            case BIT: {
                ((BitVector)vector).setNull(pos);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + vector.getMinorType());
            }
        }
    }

    public static void unsetRow(int row, Block block) {
        block22: for (FieldVector vector : block.getFieldVectors()) {
            switch (vector.getMinorType()) {
                case TIMESTAMPMILLITZ: {
                    ((TimeStampMilliTZVector)vector).setNull(row);
                    continue block22;
                }
                case DATEDAY: {
                    ((DateDayVector)vector).setNull(row);
                    continue block22;
                }
                case DATEMILLI: {
                    ((DateMilliVector)vector).setNull(row);
                    continue block22;
                }
                case TINYINT: {
                    ((TinyIntVector)vector).setNull(row);
                    continue block22;
                }
                case UINT1: {
                    ((UInt1Vector)vector).setNull(row);
                    continue block22;
                }
                case SMALLINT: {
                    ((SmallIntVector)vector).setNull(row);
                    continue block22;
                }
                case UINT2: {
                    ((UInt2Vector)vector).setNull(row);
                    continue block22;
                }
                case UINT4: {
                    ((UInt4Vector)vector).setNull(row);
                    continue block22;
                }
                case INT: {
                    ((IntVector)vector).setNull(row);
                    continue block22;
                }
                case UINT8: {
                    ((UInt8Vector)vector).setNull(row);
                    continue block22;
                }
                case BIGINT: {
                    ((BigIntVector)vector).setNull(row);
                    continue block22;
                }
                case FLOAT4: {
                    ((Float4Vector)vector).setNull(row);
                    continue block22;
                }
                case FLOAT8: {
                    ((Float8Vector)vector).setNull(row);
                    continue block22;
                }
                case DECIMAL: {
                    ((DecimalVector)vector).setNull(row);
                    continue block22;
                }
                case VARBINARY: {
                    ((VarBinaryVector)vector).setNull(row);
                    continue block22;
                }
                case VARCHAR: {
                    ((VarCharVector)vector).setNull(row);
                    continue block22;
                }
                case BIT: {
                    ((BitVector)vector).setNull(row);
                    continue block22;
                }
                case STRUCT: {
                    ((StructVector)vector).setNull(row);
                    continue block22;
                }
                case LIST: {
                    UnionListWriter writer = ((ListVector)vector).getWriter();
                    writer.setPosition(row);
                    writer.startList();
                    writer.endList();
                    writer.setValueCount(0);
                    continue block22;
                }
                case MAP: {
                    ((MapVector)vector).setNull(row);
                    continue block22;
                }
            }
            throw new IllegalArgumentException("Unknown type " + vector.getMinorType());
        }
    }

    @VisibleForTesting
    public static Class getJavaType(Types.MinorType minorType) {
        switch (minorType) {
            case TIMESTAMPMILLITZ: {
                return ZonedDateTime.class;
            }
            case DATEMILLI: {
                return java.time.LocalDateTime.class;
            }
            case TINYINT: 
            case UINT1: {
                return Byte.class;
            }
            case SMALLINT: {
                return Short.class;
            }
            case UINT2: {
                return Character.class;
            }
            case DATEDAY: {
                return LocalDate.class;
            }
            case INT: 
            case UINT4: {
                return Integer.class;
            }
            case UINT8: 
            case BIGINT: {
                return Long.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case FLOAT4: {
                return Float.class;
            }
            case FLOAT8: {
                return Double.class;
            }
            case VARCHAR: {
                return String.class;
            }
            case VARBINARY: {
                return byte[].class;
            }
            case BIT: {
                return Boolean.class;
            }
            case LIST: {
                return List.class;
            }
            case STRUCT: {
                return Map.class;
            }
        }
        throw new IllegalArgumentException("Unknown type " + minorType);
    }

    private BlockUtils() {
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    static {
        EPOCH.setDate(0L);
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    }
}

