/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.projectors;

import com.amazonaws.athena.connector.lambda.data.projectors.ArrowValueProjectorImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class ListArrowValueProjector
extends ArrowValueProjectorImpl {
    private final FieldReader listReader;
    private final ArrowValueProjectorImpl.Projection projection;

    public ListArrowValueProjector(FieldReader listReader) {
        this.listReader = Objects.requireNonNull(listReader, "listReader is null");
        List children = listReader.getField().getChildren();
        if (children.size() != 1) {
            throw new RuntimeException("Unexpected number of children for ListProjector field " + listReader.getField().getName());
        }
        Types.MinorType minorType = Types.getMinorTypeForArrowType((ArrowType)((Field)children.get(0)).getType());
        this.projection = this.createValueProjection(minorType);
    }

    @Override
    public Object project(int pos) {
        this.listReader.setPosition(pos);
        if (!this.listReader.isSet()) {
            return null;
        }
        return this.doProject();
    }

    protected Object doProject() {
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.listReader.next()) {
            FieldReader subReader = this.listReader.reader();
            if (!subReader.isSet()) {
                list.add(null);
                continue;
            }
            Object value = this.projection.doProjection(subReader);
            list.add(value);
        }
        return list;
    }
}

