/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.DateMilliExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.holders.NullableDateMilliHolder;

public class DateMilliFieldWriter
implements FieldWriter {
    private final NullableDateMilliHolder holder = new NullableDateMilliHolder();
    private final DateMilliExtractor extractor;
    private final DateMilliVector vector;
    private final ConstraintApplier constraint;

    public DateMilliFieldWriter(DateMilliExtractor extractor, DateMilliVector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(value.value), ZoneOffset.UTC)) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        this.vector.setSafe(rowNum, this.holder);
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableDateMilliHolder var1);
    }
}

