/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.SmallIntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.holders.NullableSmallIntHolder;

public class SmallIntFieldWriter
implements FieldWriter {
    private final NullableSmallIntHolder holder = new NullableSmallIntHolder();
    private final SmallIntExtractor extractor;
    private final SmallIntVector vector;
    private final ConstraintApplier constraint;

    public SmallIntFieldWriter(SmallIntExtractor extractor, SmallIntVector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : Short.valueOf(value.value)) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        this.vector.setSafe(rowNum, this.holder);
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableSmallIntHolder var1);
    }
}

