/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.ArrowTypeComparator;
import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueMarker;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueMarkerComparator;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.beans.Transient;
import java.util.Objects;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;

public class Marker
implements Comparable<ValueMarker>,
AutoCloseable,
ValueMarker {
    protected static final String DEFAULT_COLUMN = "col1";
    private final int valuePosition;
    private final Block valueBlock;
    private final Bound bound;
    private final boolean nullValue;
    private final ArrowType arrowType;
    private final Object value;

    @JsonCreator
    public Marker(@JsonProperty(value="valueBlock") Block valueBlock, @JsonProperty(value="bound") Bound bound, @JsonProperty(value="nullValue") boolean nullValue) {
        Objects.requireNonNull(valueBlock, "valueBlock is null");
        Objects.requireNonNull(bound, "bound is null");
        this.valueBlock = valueBlock;
        this.bound = bound;
        this.nullValue = nullValue;
        this.valuePosition = 0;
        this.arrowType = valueBlock.getFieldReader(DEFAULT_COLUMN).getField().getType();
        if (!nullValue) {
            FieldReader reader = valueBlock.getFieldReader(DEFAULT_COLUMN);
            reader.setPosition(this.valuePosition);
            this.value = reader.readObject();
        } else {
            this.value = null;
        }
    }

    protected Marker(Block block, int valuePosition, Bound bound, boolean nullValue) {
        Objects.requireNonNull(block, "block is null");
        Objects.requireNonNull(bound, "bound is null");
        this.valueBlock = block;
        this.bound = bound;
        this.nullValue = nullValue;
        this.valuePosition = valuePosition;
        this.arrowType = this.valueBlock.getFieldReader(DEFAULT_COLUMN).getField().getType();
        if (!nullValue) {
            FieldReader reader = this.valueBlock.getFieldReader(DEFAULT_COLUMN);
            reader.setPosition(valuePosition);
            this.value = reader.readObject();
        } else {
            this.value = null;
        }
    }

    @Override
    public boolean isNullValue() {
        return this.nullValue;
    }

    @Override
    @Transient
    public ArrowType getType() {
        return this.arrowType;
    }

    @Override
    @Transient
    public Object getValue() {
        if (this.nullValue) {
            throw new IllegalStateException("No value to get");
        }
        return this.value;
    }

    @Override
    @JsonProperty
    public Bound getBound() {
        return this.bound;
    }

    @Transient
    public Schema getSchema() {
        return this.valueBlock.getSchema();
    }

    @JsonProperty
    public Block getValueBlock() {
        if (this.valueBlock.getRowCount() > 1) {
            throw new RuntimeException("Attempting to get batch for a marker that appears to have a shared block");
        }
        return this.valueBlock;
    }

    @Override
    @Transient
    public boolean isUpperUnbounded() {
        return this.nullValue && this.bound == Bound.BELOW;
    }

    @Override
    @Transient
    public boolean isLowerUnbounded() {
        return this.nullValue && this.bound == Bound.ABOVE;
    }

    @Transient
    public boolean isAdjacent(Marker other) {
        if (this.isUpperUnbounded() || this.isLowerUnbounded() || other.isUpperUnbounded() || other.isLowerUnbounded()) {
            return false;
        }
        if (ArrowTypeComparator.compare(this.getType(), this.getValue(), other.getValue()) != 0) {
            return false;
        }
        return this.bound == Bound.EXACTLY && other.bound != Bound.EXACTLY || this.bound != Bound.EXACTLY && other.bound == Bound.EXACTLY;
    }

    public Marker greaterAdjacent() {
        if (this.nullValue) {
            throw new IllegalStateException("No marker adjacent to unbounded");
        }
        switch (this.bound) {
            case BELOW: {
                return new Marker(this.valueBlock, this.valuePosition, Bound.EXACTLY, this.nullValue);
            }
            case EXACTLY: {
                return new Marker(this.valueBlock, this.valuePosition, Bound.ABOVE, this.nullValue);
            }
            case ABOVE: {
                throw new IllegalStateException("No greater marker adjacent to an ABOVE bound");
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + this.bound));
    }

    public Marker lesserAdjacent() {
        if (this.nullValue) {
            throw new IllegalStateException("No marker adjacent to unbounded");
        }
        switch (this.bound) {
            case BELOW: {
                throw new IllegalStateException("No lesser marker adjacent to a BELOW bound");
            }
            case EXACTLY: {
                return new Marker(this.valueBlock, this.valuePosition, Bound.BELOW, this.nullValue);
            }
            case ABOVE: {
                return new Marker(this.valueBlock, this.valuePosition, Bound.EXACTLY, this.nullValue);
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + this.bound));
    }

    public static Marker min(Marker marker1, Marker marker2) {
        return marker1.compareTo(marker2) <= 0 ? marker1 : marker2;
    }

    public static Marker max(Marker marker1, Marker marker2) {
        return marker1.compareTo(marker2) >= 0 ? marker1 : marker2;
    }

    private static Marker create(BlockAllocator allocator, ArrowType type, Object value, Bound bound) {
        return new Marker(BlockUtils.newBlock(allocator, DEFAULT_COLUMN, type, value), 0, bound, false);
    }

    private static Marker create(BlockAllocator allocator, ArrowType type, Bound bound) {
        return new Marker(BlockUtils.newEmptyBlock(allocator, DEFAULT_COLUMN, type), 0, bound, true);
    }

    public static Marker upperUnbounded(BlockAllocator allocator, ArrowType type) {
        Objects.requireNonNull(type, "type is null");
        return Marker.create(allocator, type, Bound.BELOW);
    }

    public static Marker lowerUnbounded(BlockAllocator allocator, ArrowType type) {
        Objects.requireNonNull(type, "type is null");
        return Marker.create(allocator, type, Bound.ABOVE);
    }

    public static Marker above(BlockAllocator allocator, ArrowType type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        return Marker.create(allocator, type, value, Bound.ABOVE);
    }

    public static Marker exactly(BlockAllocator allocator, ArrowType type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        return Marker.create(allocator, type, value, Bound.EXACTLY);
    }

    public static Marker nullMarker(BlockAllocator allocator, ArrowType type) {
        return Marker.create(allocator, type, Bound.EXACTLY);
    }

    public static Marker below(BlockAllocator allocator, ArrowType type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        return Marker.create(allocator, type, value, Bound.BELOW);
    }

    public int hashCode() {
        if (this.nullValue) {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.nullValue, this.getType(), this.bound});
        }
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.nullValue, this.getType(), this.getValue(), this.bound});
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Marker that = (Marker)o;
        boolean bl = result = com.google.common.base.Objects.equal((Object)this.nullValue, (Object)that.nullValue) && com.google.common.base.Objects.equal((Object)this.getType(), (Object)that.getType()) && com.google.common.base.Objects.equal((Object)((Object)this.bound), (Object)((Object)that.bound));
        if (result && !this.nullValue) {
            result = com.google.common.base.Objects.equal((Object)this.getValue(), (Object)that.getValue());
        }
        return result;
    }

    @Override
    public int compareTo(ValueMarker o) {
        return ValueMarkerComparator.doCompare(this, o);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("valueBlock", (Object)this.getType()).add("nullValue", this.nullValue).add("valueBlock", this.nullValue ? Boolean.valueOf(this.nullValue) : this.getValue()).add("bound", (Object)this.bound).toString();
    }

    @Override
    public void close() throws Exception {
        this.valueBlock.close();
    }

    public static enum Bound {
        BELOW,
        EXACTLY,
        ABOVE;

    }
}

