/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.domain.predicate.AllOrNoneValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.EquatableValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.Ranges;
import com.amazonaws.athena.connector.lambda.domain.predicate.SortedRangeSet;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.beans.Transient;
import java.util.Collection;
import org.apache.arrow.vector.types.pojo.ArrowType;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EquatableValueSet.class, name="equatable"), @JsonSubTypes.Type(value=SortedRangeSet.class, name="sortable"), @JsonSubTypes.Type(value=AllOrNoneValueSet.class, name="allOrNone")})
public interface ValueSet
extends AutoCloseable {
    public ArrowType getType();

    @Transient
    public boolean isNone();

    @Transient
    public boolean isAll();

    @Transient
    public boolean isSingleValue();

    @Transient
    public Object getSingleValue();

    public boolean isNullAllowed();

    public boolean containsValue(Marker var1);

    public boolean containsValue(Object var1);

    @Transient
    default public Ranges getRanges() {
        throw new UnsupportedOperationException();
    }

    public ValueSet intersect(BlockAllocator var1, ValueSet var2);

    public ValueSet union(BlockAllocator var1, ValueSet var2);

    default public ValueSet union(BlockAllocator allocator, Collection<ValueSet> valueSets) {
        ValueSet current = this;
        for (ValueSet valueSet : valueSets) {
            current = current.union(allocator, valueSet);
        }
        return current;
    }

    public ValueSet complement(BlockAllocator var1);

    default public boolean overlaps(BlockAllocator allocator, ValueSet other) {
        return !this.intersect(allocator, other).isNone();
    }

    default public ValueSet subtract(BlockAllocator allocator, ValueSet other) {
        return this.intersect(allocator, other.complement(allocator));
    }

    default public boolean contains(BlockAllocator allocator, ValueSet other) {
        return this.union(allocator, other).equals(this);
    }
}

