/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.examples;

import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockWriter;
import com.amazonaws.athena.connector.lambda.data.FieldBuilder;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.examples.ContinuationToken;
import com.amazonaws.athena.connector.lambda.examples.SplitProperties;
import com.amazonaws.athena.connector.lambda.exceptions.FederationThrottleException;
import com.amazonaws.athena.connector.lambda.handlers.MetadataHandler;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesResponse;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.request.PingRequest;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.amazonaws.athena.connector.lambda.security.EncryptionKeyFactory;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleMetadataHandler
extends MetadataHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExampleMetadataHandler.class);
    private static final String SOURCE_TYPE = "custom";
    private static final String SIMULATE_THROTTLES = "SIMULATE_THROTTLES";
    protected static final int NUM_PARTS_PER_SPLIT = 10;
    protected static final int MAX_SPLITS_PER_REQUEST = 300;
    protected static final String PARTITION_LOCATION = "location";
    protected static final String SERDE = "serde";
    private final int simulateThrottle = System.getenv("SIMULATE_THROTTLES") == null ? 0 : Integer.parseInt(System.getenv("SIMULATE_THROTTLES"));
    private boolean encryptionEnabled = true;
    private int count = 0;

    public ExampleMetadataHandler() {
        super(SOURCE_TYPE);
    }

    @VisibleForTesting
    protected ExampleMetadataHandler(EncryptionKeyFactory keyFactory, AWSSecretsManager awsSecretsManager, AmazonAthena athena, String spillBucket, String spillPrefix) {
        super(keyFactory, awsSecretsManager, athena, SOURCE_TYPE, spillBucket, spillPrefix);
    }

    @VisibleForTesting
    protected void setEncryption(boolean enableEncryption) {
        this.encryptionEnabled = enableEncryption;
    }

    private void logCaller(FederationRequest request) {
        FederatedIdentity identity = request.getIdentity();
        logger.info("logCaller: account[" + identity.getAccount() + "] arn[" + identity.getArn() + "]");
    }

    @Override
    public ListSchemasResponse doListSchemaNames(BlockAllocator allocator, ListSchemasRequest request) {
        this.logCaller(request);
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add("custom_source");
        return new ListSchemasResponse(request.getCatalogName(), schemas);
    }

    @Override
    public ListTablesResponse doListTables(BlockAllocator allocator, ListTablesRequest request) {
        this.logCaller(request);
        String nextToken = null;
        int pageSize = request.getPageSize();
        Object tables = new ImmutableList.Builder().add((Object)new TableName("schema", "table4")).add((Object)new TableName("schema", "table3")).add((Object)new TableName("schema", "table5")).add((Object)new TableName("schema", "table1")).add((Object)new TableName("schema", "table2")).build();
        if (pageSize != -1) {
            String startToken = request.getNextToken();
            List paginatedTables = tables.stream().sorted(Comparator.comparing(TableName::getTableName)).filter(table -> startToken == null || table.getTableName().compareTo(startToken) >= 0).limit(pageSize + 1).collect(Collectors.toList());
            if (paginatedTables.size() > pageSize) {
                nextToken = ((TableName)paginatedTables.get(pageSize)).getTableName();
                tables = paginatedTables.subList(0, pageSize);
            } else {
                tables = paginatedTables;
            }
        }
        return new ListTablesResponse(request.getCatalogName(), tables.stream().filter(table -> request.getSchemaName() == null || request.getSchemaName().equals(table.getSchemaName())).collect(Collectors.toList()), nextToken);
    }

    @Override
    public GetTableResponse doGetTable(BlockAllocator allocator, GetTableRequest request) {
        this.logCaller(request);
        if (!request.getTableName().getSchemaName().equals("custom_source") || !request.getTableName().getTableName().equals("fake_table")) {
            throw new IllegalArgumentException("Unknown table " + request.getTableName());
        }
        HashSet<String> partitionCols = new HashSet<String>();
        partitionCols.add("month");
        partitionCols.add("year");
        partitionCols.add("day");
        return new GetTableResponse(request.getCatalogName(), request.getTableName(), ExampleTable.schema, partitionCols);
    }

    @Override
    public void enhancePartitionSchema(SchemaBuilder partitionSchemaBuilder, GetTableLayoutRequest request) {
        partitionSchemaBuilder.addField(PARTITION_LOCATION, (ArrowType)new ArrowType.Utf8()).addField(SERDE, (ArrowType)new ArrowType.Utf8());
    }

    @Override
    public void getPartitions(BlockWriter writer, GetTableLayoutRequest request, QueryStatusChecker queryStatusChecker) {
        this.logCaller(request);
        for (int year = 1990; year < 2020; ++year) {
            for (int month = 0; month < 12; ++month) {
                int day = 0;
                while (day < 30) {
                    int dayVal = day++;
                    int monthVal = month;
                    int yearVal = year;
                    writer.writeRows((block, rowNum) -> {
                        boolean matched = true;
                        matched &= block.setValue("day", rowNum, dayVal);
                        matched &= block.setValue("month", rowNum, monthVal);
                        matched &= block.setValue("year", rowNum, yearVal);
                        matched &= block.setValue(PARTITION_LOCATION, rowNum, "s3://" + request.getPartitionCols());
                        return (matched &= block.setValue(SERDE, rowNum, "TextInputFormat")) ? 1 : 0;
                    });
                }
            }
        }
    }

    @Override
    public GetSplitsResponse doGetSplits(BlockAllocator allocator, GetSplitsRequest request) {
        this.logCaller(request);
        logger.info("doGetSplits: spill location " + this.makeSpillLocation(request));
        if (this.simulateThrottle > 0 && this.count++ % this.simulateThrottle == 0) {
            logger.info("readWithConstraint: throwing throttle Exception!");
            throw new FederationThrottleException("Please slow down for this simulated throttling event");
        }
        ContinuationToken requestToken = ContinuationToken.decode(request.getContinuationToken());
        int partitionContd = requestToken.getPartition();
        int partContd = requestToken.getPart();
        HashSet<Split> splits = new HashSet<Split>();
        Block partitions = request.getPartitions();
        for (int curPartition = partitionContd; curPartition < partitions.getRowCount(); ++curPartition) {
            EncryptionKey encryptionKey = this.makeEncryptionKey();
            FieldReader locationReader = partitions.getFieldReader(SplitProperties.LOCATION.getId());
            locationReader.setPosition(curPartition);
            FieldReader storageClassReader = partitions.getFieldReader(SplitProperties.SERDE.getId());
            storageClassReader.setPosition(curPartition);
            for (int curPart = partContd; curPart < 10; ++curPart) {
                if (splits.size() >= 300) {
                    return new GetSplitsResponse(request.getCatalogName(), splits, ContinuationToken.encode(curPartition, curPart));
                }
                Split.Builder splitBuilder = Split.newBuilder(this.makeSpillLocation(request), this.encryptionEnabled ? encryptionKey : null).add(SplitProperties.LOCATION.getId(), String.valueOf(locationReader.readText())).add(SplitProperties.SERDE.getId(), String.valueOf(storageClassReader.readText())).add(SplitProperties.SPLIT_PART.getId(), String.valueOf(curPart));
                block7: for (String next : request.getPartitionCols()) {
                    FieldReader reader = partitions.getFieldReader(next);
                    reader.setPosition(curPartition);
                    switch (reader.getMinorType()) {
                        case UINT2: {
                            splitBuilder.add(next, Integer.valueOf(reader.readCharacter().charValue()).toString());
                            continue block7;
                        }
                        case UINT4: 
                        case INT: {
                            splitBuilder.add(next, String.valueOf(reader.readInteger()));
                            continue block7;
                        }
                        case UINT8: 
                        case BIGINT: {
                            splitBuilder.add(next, String.valueOf(reader.readLong()));
                            continue block7;
                        }
                    }
                    throw new RuntimeException("Unsupported partition column type. " + reader.getMinorType());
                }
                splits.add(splitBuilder.build());
            }
            partContd = 0;
        }
        return new GetSplitsResponse(request.getCatalogName(), splits, null);
    }

    @Override
    public void onPing(PingRequest request) {
        this.logCaller(request);
    }

    protected static class ExampleTable {
        public static final String schemaName = "custom_source";
        public static final String tableName = "fake_table";
        public static final Schema schema;

        private ExampleTable() {
        }

        static {
            new SchemaBuilder();
            schema = SchemaBuilder.newBuilder().addField("col1", (ArrowType)new ArrowType.Date(DateUnit.DAY)).addField("day", (ArrowType)new ArrowType.Int(32, true)).addField("month", (ArrowType)new ArrowType.Int(32, true)).addField("year", (ArrowType)new ArrowType.Int(32, true)).addField("col3", (ArrowType)new ArrowType.Bool()).addField("col4", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)).addField("col5", (ArrowType)new ArrowType.Utf8()).addField("datemilli", Types.MinorType.DATEMILLI.getType()).addField("int", Types.MinorType.INT.getType()).addField("tinyint", Types.MinorType.TINYINT.getType()).addField("smallint", Types.MinorType.SMALLINT.getType()).addField("bigint", Types.MinorType.BIGINT.getType()).addField("float4", Types.MinorType.FLOAT4.getType()).addField("float8", Types.MinorType.FLOAT8.getType()).addField("bit", Types.MinorType.BIT.getType()).addField("varchar", Types.MinorType.VARCHAR.getType()).addField("varbinary", Types.MinorType.VARBINARY.getType()).addField("decimal", (ArrowType)new ArrowType.Decimal(10, 2)).addField("decimalLong", (ArrowType)new ArrowType.Decimal(36, 2)).addField(FieldBuilder.newBuilder("list", (ArrowType)new ArrowType.List()).addField(FieldBuilder.newBuilder("innerStruct", Types.MinorType.STRUCT.getType()).addStringField("varchar").addBigIntField("bigint").build()).build()).addField(FieldBuilder.newBuilder("outerlist", (ArrowType)new ArrowType.List()).addListField("innerList", Types.MinorType.VARCHAR.getType()).build()).addField(FieldBuilder.newBuilder("simplemap", (ArrowType)new ArrowType.Map(false)).addField("entries", Types.MinorType.STRUCT.getType(), false, Arrays.asList(FieldBuilder.newBuilder("key", Types.MinorType.VARCHAR.getType(), false).build(), FieldBuilder.newBuilder("value", Types.MinorType.INT.getType()).build())).build()).addMetadata("partitionCols", "day,month,year").addMetadata("randomProp1", "randomPropVal1").addMetadata("randomProp2", "randomPropVal2").build();
        }
    }
}

