/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.handlers;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.handlers.MetadataHandler;
import com.amazonaws.athena.connector.lambda.handlers.RecordHandler;
import com.amazonaws.athena.connector.lambda.handlers.UserDefinedFunctionHandler;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.records.RecordRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.request.PingRequest;
import com.amazonaws.athena.connector.lambda.request.PingResponse;
import com.amazonaws.athena.connector.lambda.serde.VersionedObjectMapperFactory;
import com.amazonaws.athena.connector.lambda.udf.UserDefinedFunctionRequest;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeHandler
implements RequestStreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(CompositeHandler.class);
    private final MetadataHandler metadataHandler;
    private final RecordHandler recordHandler;
    private final UserDefinedFunctionHandler udfhandler;

    public CompositeHandler(MetadataHandler metadataHandler, RecordHandler recordHandler) {
        this.metadataHandler = metadataHandler;
        this.recordHandler = recordHandler;
        this.udfhandler = null;
    }

    public CompositeHandler(MetadataHandler metadataHandler, RecordHandler recordHandler, UserDefinedFunctionHandler udfhandler) {
        this.metadataHandler = metadataHandler;
        this.recordHandler = recordHandler;
        this.udfhandler = udfhandler;
    }

    public final void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        try (BlockAllocatorImpl allocator = new BlockAllocatorImpl();){
            ObjectMapper objectMapper = VersionedObjectMapperFactory.create(allocator);
            try (FederationRequest rawReq = (FederationRequest)objectMapper.readValue(inputStream, FederationRequest.class);){
                if (rawReq instanceof MetadataRequest) {
                    ((MetadataRequest)rawReq).setContext(context);
                }
                this.handleRequest(allocator, rawReq, outputStream, objectMapper);
            }
        }
        catch (Exception ex) {
            logger.warn("handleRequest: Completed with an exception.", (Throwable)ex);
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
    }

    public final void handleRequest(BlockAllocator allocator, FederationRequest rawReq, OutputStream outputStream, ObjectMapper objectMapper) throws Exception {
        if (rawReq instanceof PingRequest) {
            try (PingResponse response = this.metadataHandler.doPing((PingRequest)rawReq);){
                this.assertNotNull(response);
                objectMapper.writeValue(outputStream, (Object)response);
            }
            return;
        }
        if (rawReq instanceof MetadataRequest) {
            this.metadataHandler.doHandleRequest(allocator, objectMapper, (MetadataRequest)rawReq, outputStream);
        } else if (rawReq instanceof RecordRequest) {
            this.recordHandler.doHandleRequest(allocator, objectMapper, (RecordRequest)rawReq, outputStream);
        } else if (this.udfhandler != null && rawReq instanceof UserDefinedFunctionRequest) {
            this.udfhandler.doHandleRequest(allocator, objectMapper, (UserDefinedFunctionRequest)rawReq, outputStream);
        } else {
            throw new IllegalArgumentException("Unknown request class " + rawReq.getClass());
        }
    }

    private void assertNotNull(FederationResponse response) {
        if (response == null) {
            throw new RuntimeException("Response was null");
        }
    }
}

