/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata;

import com.amazonaws.athena.connector.lambda.CollectionsUtils;
import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.beans.Transient;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Schema;

public class GetSplitsRequest
extends MetadataRequest {
    private final TableName tableName;
    private final Block partitions;
    private final List<String> partitionCols;
    private final Constraints constraints;
    private final String continuationToken;

    @JsonCreator
    public GetSplitsRequest(@JsonProperty(value="identity") FederatedIdentity identity, @JsonProperty(value="queryId") String queryId, @JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="tableName") TableName tableName, @JsonProperty(value="partitions") Block partitions, @JsonProperty(value="partitionCols") List<String> partitionCols, @JsonProperty(value="constraints") Constraints constraints, @JsonProperty(value="continuationToken") String continuationToken) {
        super(identity, MetadataRequestType.GET_SPLITS, queryId, catalogName);
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(partitions, "partitions is null");
        Objects.requireNonNull(partitionCols, "partitionCols is null");
        Objects.requireNonNull(constraints, "constraints is null");
        this.tableName = tableName;
        this.partitions = partitions;
        this.partitionCols = Collections.unmodifiableList(partitionCols);
        this.constraints = constraints;
        this.continuationToken = continuationToken;
    }

    public GetSplitsRequest(GetSplitsRequest clone, String continuationToken) {
        this(clone.getIdentity(), clone.getQueryId(), clone.getCatalogName(), clone.tableName, clone.partitions, clone.partitionCols, clone.constraints, continuationToken);
    }

    @JsonProperty
    public String getContinuationToken() {
        return this.continuationToken;
    }

    @JsonProperty
    public TableName getTableName() {
        return this.tableName;
    }

    @Transient
    public Schema getSchema() {
        return this.partitions.getSchema();
    }

    @JsonProperty
    public List<String> getPartitionCols() {
        return this.partitionCols;
    }

    @JsonProperty
    public Block getPartitions() {
        return this.partitions;
    }

    @JsonProperty
    public Constraints getConstraints() {
        return this.constraints;
    }

    @Transient
    public boolean hasContinuationToken() {
        return this.continuationToken != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.getQueryId()).add("tableName", (Object)this.tableName).add("partitionCols", this.partitionCols).add("requestType", (Object)this.getRequestType()).add("catalogName", (Object)this.getCatalogName()).add("partitions", (Object)this.partitions).add("constraints", (Object)this.constraints).add("continuationToken", (Object)this.continuationToken).toString();
    }

    @Override
    public void close() throws Exception {
        this.partitions.close();
        this.constraints.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSplitsRequest that = (GetSplitsRequest)o;
        com.google.common.base.Objects.equal((Object)this.tableName, (Object)that.tableName);
        com.google.common.base.Objects.equal((Object)this.partitions, (Object)that.partitions);
        CollectionsUtils.equals(this.partitionCols, that.partitionCols);
        com.google.common.base.Objects.equal((Object)this.continuationToken, (Object)that.continuationToken);
        com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType()));
        com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName());
        return com.google.common.base.Objects.equal((Object)this.tableName, (Object)that.tableName) && com.google.common.base.Objects.equal((Object)this.partitions, (Object)that.partitions) && CollectionsUtils.equals(this.partitionCols, that.partitionCols) && com.google.common.base.Objects.equal((Object)this.continuationToken, (Object)that.continuationToken) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.tableName, this.partitions, this.partitionCols, this.continuationToken, this.getRequestType(), this.getCatalogName()});
    }
}

