/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata;

import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.metadata.MetadataResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class GetSplitsResponse
extends MetadataResponse {
    private final Set<Split> splits;
    private final String continuationToken;

    @JsonCreator
    public GetSplitsResponse(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="splits") Set<Split> splits, @JsonProperty(value="continuationToken") String continuationToken) {
        super(MetadataRequestType.GET_SPLITS, catalogName);
        Objects.requireNonNull(splits, "splits is null");
        this.splits = Collections.unmodifiableSet(splits);
        this.continuationToken = continuationToken;
    }

    public GetSplitsResponse(String catalogName, Set<Split> splits) {
        super(MetadataRequestType.GET_SPLITS, catalogName);
        Objects.requireNonNull(splits, "splits is null");
        this.splits = Collections.unmodifiableSet(splits);
        this.continuationToken = null;
    }

    public GetSplitsResponse(String catalogName, Split split) {
        super(MetadataRequestType.GET_SPLITS, catalogName);
        Objects.requireNonNull(split, "split is null");
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(split);
        this.splits = Collections.unmodifiableSet(splits);
        this.continuationToken = null;
    }

    @JsonProperty
    public Set<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty
    public String getContinuationToken() {
        return this.continuationToken;
    }

    @Override
    public void close() throws Exception {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSplitsResponse that = (GetSplitsResponse)o;
        return com.google.common.base.Objects.equal(this.splits, that.splits) && com.google.common.base.Objects.equal((Object)this.continuationToken, (Object)that.continuationToken) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.splits, this.continuationToken, this.getRequestType(), this.getCatalogName()});
    }

    public String toString() {
        return "GetSplitsResponse{splitSize=" + this.splits.size() + ", continuationToken='" + this.continuationToken + "'}";
    }
}

