/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata;

import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class GetTableRequest
extends MetadataRequest {
    private final TableName tableName;

    @JsonCreator
    public GetTableRequest(@JsonProperty(value="identity") FederatedIdentity identity, @JsonProperty(value="queryId") String queryId, @JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="tableName") TableName tableName) {
        super(identity, MetadataRequestType.GET_TABLE, queryId, catalogName);
        Objects.requireNonNull(tableName, "tableName is null");
        this.tableName = tableName;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public void close() throws Exception {
    }

    public String toString() {
        return "GetTableRequest{queryId=" + this.getQueryId() + ", tableName=" + this.tableName + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTableRequest that = (GetTableRequest)o;
        return com.google.common.base.Objects.equal((Object)this.tableName, (Object)that.tableName) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.tableName, this.getRequestType(), this.getCatalogName()});
    }
}

