/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata;

import com.amazonaws.athena.connector.lambda.CollectionsUtils;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.metadata.MetadataResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class ListTablesResponse
extends MetadataResponse {
    private final Collection<TableName> tables;
    private final String nextToken;

    @JsonCreator
    public ListTablesResponse(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="tables") Collection<TableName> tables, @JsonProperty(value="nextToken") String nextToken) {
        super(MetadataRequestType.LIST_TABLES, catalogName);
        Objects.requireNonNull(tables, "tables is null");
        this.tables = Collections.unmodifiableCollection(tables);
        this.nextToken = nextToken;
    }

    public Collection<TableName> getTables() {
        return this.tables;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    @Override
    public void close() throws Exception {
    }

    public String toString() {
        return "ListTablesResponse{tables=" + this.tables + ", nextToken='" + this.nextToken + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTablesResponse that = (ListTablesResponse)o;
        return CollectionsUtils.equals(this.tables, that.tables) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName()) && com.google.common.base.Objects.equal((Object)this.getNextToken(), (Object)that.getNextToken());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.tables, this.getRequestType(), this.getCatalogName(), this.getNextToken()});
    }
}

