/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata.glue;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class DefaultGlueType {
    private static final String TIMESTAMPMILLITZ = "timestamptz";
    private static final Set<String> NON_COMPARABALE_SET = Set.of("TIMESTAMPMILLITZ");
    private static final Map<String, ArrowType> TYPE_MAP = Map.ofEntries(Map.entry("int", Types.MinorType.INT.getType()), Map.entry("varchar", Types.MinorType.VARCHAR.getType()), Map.entry("string", Types.MinorType.VARCHAR.getType()), Map.entry("bigint", Types.MinorType.BIGINT.getType()), Map.entry("double", Types.MinorType.FLOAT8.getType()), Map.entry("float", Types.MinorType.FLOAT4.getType()), Map.entry("smallint", Types.MinorType.SMALLINT.getType()), Map.entry("tinyint", Types.MinorType.TINYINT.getType()), Map.entry("boolean", Types.MinorType.BIT.getType()), Map.entry("binary", Types.MinorType.VARBINARY.getType()), Map.entry("timestamp", Types.MinorType.DATEMILLI.getType()), Map.entry("date", Types.MinorType.DATEDAY.getType()), Map.entry("timestamptz", new ArrowType.Timestamp(TimeUnit.MILLISECOND, ZoneId.systemDefault().getId())));
    private static final Pattern decimalPattern = Pattern.compile("decimal([(](([0-9]+,?){2,3})[)])?");
    private String id;
    private ArrowType arrowType;

    DefaultGlueType(String id, ArrowType arrowType) {
        this.id = id;
        this.arrowType = arrowType;
    }

    private static ArrowType getDecimalArrowType(String in) {
        Matcher decimalMatcher = decimalPattern.matcher(in);
        if (!decimalMatcher.matches()) {
            return null;
        }
        try {
            int[] params = Arrays.stream(decimalMatcher.group(2).split(",")).mapToInt(Integer::parseInt).toArray();
            if (params.length == 2) {
                return new ArrowType.Decimal(params[0], params[1]);
            }
            return new ArrowType.Decimal(params[0], params[1], params[2]);
        }
        catch (NullPointerException e) {
            return new ArrowType.Decimal(38, 18);
        }
    }

    public static ArrowType fromId(String id) {
        ArrowType result = DefaultGlueType.toArrowType(id);
        if (result == null) {
            throw new IllegalArgumentException("Unknown DefaultGlueType for id: " + id);
        }
        return result;
    }

    public static ArrowType toArrowType(String id) {
        ArrowType result = TYPE_MAP.get(id.toLowerCase());
        if (result == null) {
            return DefaultGlueType.getDecimalArrowType(id);
        }
        return result;
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    public static Set<String> getNonComparableSet() {
        return NON_COMPARABALE_SET;
    }
}

