/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata.glue;

import com.amazonaws.athena.connector.lambda.data.FieldBuilder;
import com.amazonaws.athena.connector.lambda.metadata.glue.DefaultGlueType;
import com.amazonaws.athena.connector.lambda.metadata.glue.GlueTypeParser;
import java.util.Set;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueFieldLexer {
    private static final Logger logger = LoggerFactory.getLogger(GlueFieldLexer.class);
    private static final String STRUCT = "struct";
    private static final String MAP = "map";
    private static final Set<String> LIST_EQUIVALENTS = Set.of("array", "set");
    private static final BaseTypeMapper DEFAULT_TYPE_MAPPER = type -> DefaultGlueType.toArrowType(type);
    public static final boolean MAP_DISABLED = true;

    private GlueFieldLexer() {
    }

    public static Field lex(String name, String input) {
        return GlueFieldLexer.lex(name, input, DEFAULT_TYPE_MAPPER);
    }

    public static Field lex(String name, String input, BaseTypeMapper mapper) {
        GlueTypeParser parser = new GlueTypeParser(input);
        return GlueFieldLexer.lexInternal(name, parser, mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field lexInternal(String name, GlueTypeParser parser, BaseTypeMapper mapper) {
        logger.debug("lexInternal: enter - {}", (Object)name);
        try {
            GlueTypeParser.Token typeToken = parser.next();
            String typeTokenValueLower = typeToken.getValue().toLowerCase();
            if (typeTokenValueLower.equals(STRUCT)) {
                Field field = GlueFieldLexer.parseStruct(name, typeToken, parser, mapper);
                return field;
            }
            if (typeTokenValueLower.equals(MAP)) {
                Field field = GlueFieldLexer.parseMap(name, typeToken, parser, mapper);
                return field;
            }
            if (LIST_EQUIVALENTS.contains(typeTokenValueLower)) {
                Field field = GlueFieldLexer.parseList(name, typeToken, parser, mapper);
                return field;
            }
            GlueFieldLexer.expectTokenMarkerIsFieldEnd(typeToken);
            Field field = mapper.getField(name, typeTokenValueLower);
            return field;
        }
        finally {
            logger.debug("lexInternal: exit - {}", (Object)name);
        }
    }

    private static Field parseStruct(String name, GlueTypeParser.Token typeToken, GlueTypeParser parser, BaseTypeMapper mapper) {
        GlueTypeParser.Token childNameToken;
        GlueFieldLexer.expectTokenMarkerIsFieldStart(typeToken);
        FieldBuilder fieldBuilder = FieldBuilder.newBuilder(name, Types.MinorType.STRUCT.getType());
        while (parser.hasNext() && (childNameToken = parser.next()).getMarker().equals(GlueTypeParser.FIELD_DIV)) {
            Field child = GlueFieldLexer.lexInternal(childNameToken.getValue(), parser, mapper);
            fieldBuilder.addField(child);
        }
        GlueFieldLexer.expectTokenMarkerIsFieldEnd(parser.currentToken());
        return fieldBuilder.build();
    }

    private static Field parseList(String name, GlueTypeParser.Token typeToken, GlueTypeParser parser, BaseTypeMapper mapper) {
        GlueFieldLexer.expectTokenMarkerIsFieldStart(typeToken);
        Field child = GlueFieldLexer.lexInternal(name, parser, mapper);
        GlueTypeParser.Token closingToken = parser.next();
        GlueFieldLexer.expectTokenMarkerIsFieldEnd(closingToken);
        return FieldBuilder.newBuilder(name, Types.MinorType.LIST.getType()).addField(child).build();
    }

    private static Field parseMap(String name, GlueTypeParser.Token typeToken, GlueTypeParser parser, BaseTypeMapper mapper) {
        throw new RuntimeException("Map type is currently unsupported");
    }

    private static void expectTokenMarkerIsFieldStart(GlueTypeParser.Token token) {
        if (token.getMarker() != GlueTypeParser.FIELD_START) {
            throw new RuntimeException("Expected field start: but found " + token.toString());
        }
    }

    private static void expectTokenMarkerIsFieldEnd(GlueTypeParser.Token token) {
        boolean isFieldEnd;
        boolean bl = isFieldEnd = token.getMarker() == null || token.getMarker().equals(GlueTypeParser.FIELD_SEP) || token.getMarker().equals(GlueTypeParser.FIELD_END);
        if (!isFieldEnd) {
            throw new RuntimeException("Expected field ending but found: " + token.toString());
        }
    }

    public static interface BaseTypeMapper {
        public ArrowType getType(String var1);

        default public Field getField(String name, String type) {
            if (this.getType(type) != null) {
                return FieldBuilder.newBuilder(name, this.getType(type)).build();
            }
            return null;
        }
    }
}

