/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.ValueSetSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public final class ConstraintsSerDe {
    private static final String SUMMARY_FIELD = "summary";

    private ConstraintsSerDe() {
    }

    public static final class Deserializer
    extends BaseDeserializer<Constraints> {
        private final ValueSetSerDe.Deserializer valueSetDeserializer;

        public Deserializer(ValueSetSerDe.Deserializer valueSetDeserializer) {
            super(Constraints.class);
            this.valueSetDeserializer = Objects.requireNonNull(valueSetDeserializer, "valueSetSerDe is null");
        }

        @Override
        public Constraints doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, ConstraintsSerDe.SUMMARY_FIELD);
            this.validateObjectStart(jparser.nextToken());
            ImmutableMap.Builder summaryMap = ImmutableMap.builder();
            while (jparser.nextToken() != JsonToken.END_OBJECT) {
                String column = jparser.getCurrentName();
                summaryMap.put((Object)column, (Object)((ValueSet)this.valueSetDeserializer.deserialize(jparser, ctxt)));
            }
            return new Constraints((Map<String, ValueSet>)summaryMap.build());
        }
    }

    public static final class Serializer
    extends BaseSerializer<Constraints> {
        private final ValueSetSerDe.Serializer valueSetSerializer;

        public Serializer(ValueSetSerDe.Serializer valueSetSerializer) {
            super(Constraints.class);
            this.valueSetSerializer = Objects.requireNonNull(valueSetSerializer, "valueSetSerDe is null");
        }

        @Override
        public void doSerialize(Constraints constraints, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObjectFieldStart(ConstraintsSerDe.SUMMARY_FIELD);
            for (Map.Entry<String, ValueSet> entry : constraints.getSummary().entrySet()) {
                jgen.writeFieldName(entry.getKey());
                this.valueSetSerializer.serialize(entry.getValue(), jgen, provider);
            }
            jgen.writeEndObject();
        }
    }
}

