/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.serde.FederatedIdentitySerDe;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ConstraintsSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.MetadataRequestDeserializer;
import com.amazonaws.athena.connector.lambda.serde.v2.MetadataRequestSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.TableNameSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.arrow.vector.types.pojo.Schema;

public final class GetTableLayoutRequestSerDe {
    private static final String IDENTITY_FIELD = "identity";
    private static final String QUERY_ID_FIELD = "queryId";
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String TABLE_NAME_FIELD = "tableName";
    private static final String CONSTRAINTS_FIELD = "constraints";
    private static final String SCHEMA_FIELD = "schema";
    private static final String PARTITION_COLS_FIELD = "partitionColumns";

    private GetTableLayoutRequestSerDe() {
    }

    public static final class Deserializer
    extends MetadataRequestDeserializer {
        private final FederatedIdentitySerDe.Deserializer identityDeserializer;
        private final TableNameSerDe.Deserializer tableNameDeserializer;
        private final ConstraintsSerDe.Deserializer constraintsDeserializer;
        private final VersionedSerDe.Deserializer<Schema> schemaDeserializer;

        public Deserializer(FederatedIdentitySerDe.Deserializer identityDeserializer, TableNameSerDe.Deserializer tableNameDeserializer, ConstraintsSerDe.Deserializer constraintsDeserializer, VersionedSerDe.Deserializer<Schema> schemaDeserializer) {
            super(GetTableLayoutRequest.class, identityDeserializer);
            this.identityDeserializer = Objects.requireNonNull(identityDeserializer, "identityDeserializer is null");
            this.tableNameDeserializer = Objects.requireNonNull(tableNameDeserializer, "tableNameDeserializer is null");
            this.constraintsDeserializer = Objects.requireNonNull(constraintsDeserializer, "constraintsDeserializer is null");
            this.schemaDeserializer = Objects.requireNonNull(schemaDeserializer, "schemaDeserializer is null");
        }

        @Override
        protected MetadataRequest doRequestDeserialize(JsonParser jparser, DeserializationContext ctxt, FederatedIdentity identity, String queryId, String catalogName) throws IOException {
            this.assertFieldName(jparser, GetTableLayoutRequestSerDe.TABLE_NAME_FIELD);
            TableName tableName = (TableName)this.tableNameDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, GetTableLayoutRequestSerDe.CONSTRAINTS_FIELD);
            Constraints constraints = (Constraints)this.constraintsDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, GetTableLayoutRequestSerDe.SCHEMA_FIELD);
            Schema schema = this.schemaDeserializer.deserialize(jparser, ctxt);
            ImmutableSet.Builder partitionColsSet = ImmutableSet.builder();
            partitionColsSet.addAll(this.getNextStringArray(jparser, GetTableLayoutRequestSerDe.PARTITION_COLS_FIELD));
            return new GetTableLayoutRequest(identity, queryId, catalogName, tableName, constraints, schema, (Set<String>)partitionColsSet.build());
        }
    }

    public static final class Serializer
    extends MetadataRequestSerializer {
        private final FederatedIdentitySerDe.Serializer identitySerializer;
        private final TableNameSerDe.Serializer tableNameSerializer;
        private final ConstraintsSerDe.Serializer constraintsSerializer;
        private final VersionedSerDe.Serializer<Schema> schemaSerializer;

        public Serializer(FederatedIdentitySerDe.Serializer identitySerializer, TableNameSerDe.Serializer tableNameSerializer, ConstraintsSerDe.Serializer constraintsSerializer, VersionedSerDe.Serializer<Schema> schemaSerializer) {
            super(GetTableLayoutRequest.class, identitySerializer);
            this.identitySerializer = Objects.requireNonNull(identitySerializer, "identitySerializer is null");
            this.tableNameSerializer = Objects.requireNonNull(tableNameSerializer, "tableNameSerializer is null");
            this.constraintsSerializer = Objects.requireNonNull(constraintsSerializer, "constraintsSerializer is null");
            this.schemaSerializer = Objects.requireNonNull(schemaSerializer, "schemaSerializer is null");
        }

        @Override
        protected void doRequestSerialize(FederationRequest federationRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            GetTableLayoutRequest getTableLayoutRequest = (GetTableLayoutRequest)federationRequest;
            jgen.writeFieldName(GetTableLayoutRequestSerDe.TABLE_NAME_FIELD);
            this.tableNameSerializer.serialize(getTableLayoutRequest.getTableName(), jgen, provider);
            jgen.writeFieldName(GetTableLayoutRequestSerDe.CONSTRAINTS_FIELD);
            this.constraintsSerializer.serialize(getTableLayoutRequest.getConstraints(), jgen, provider);
            jgen.writeFieldName(GetTableLayoutRequestSerDe.SCHEMA_FIELD);
            this.schemaSerializer.serialize(getTableLayoutRequest.getSchema(), jgen, provider);
            this.writeStringArray(jgen, GetTableLayoutRequestSerDe.PARTITION_COLS_FIELD, getTableLayoutRequest.getPartitionCols());
        }
    }
}

