/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public final class TableNameSerDe {
    private static final String SCHEMA_NAME_FIELD = "schemaName";
    private static final String TABLE_NAME_FIELD = "tableName";

    private TableNameSerDe() {
    }

    public static final class Deserializer
    extends BaseDeserializer<TableName> {
        public Deserializer() {
            super(TableName.class);
        }

        @Override
        public TableName doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String schemaName = this.getNextStringField(jparser, TableNameSerDe.SCHEMA_NAME_FIELD);
            String tableName = this.getNextStringField(jparser, TableNameSerDe.TABLE_NAME_FIELD);
            return new TableName(schemaName, tableName);
        }
    }

    public static final class Serializer
    extends BaseSerializer<TableName> {
        public Serializer() {
            super(TableName.class);
        }

        @Override
        public void doSerialize(TableName tableName, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStringField(TableNameSerDe.SCHEMA_NAME_FIELD, tableName.getSchemaName());
            jgen.writeStringField(TableNameSerDe.TABLE_NAME_FIELD, tableName.getTableName());
        }
    }
}

