/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.credentials;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceAsyncClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossAccountCredentialsProvider {
    private static final String CROSS_ACCOUNT_ROLE_ARN_CONFIG = "cross_account_role_arn";
    private static final Logger logger = LoggerFactory.getLogger(CrossAccountCredentialsProvider.class);

    private CrossAccountCredentialsProvider() {
    }

    public static AWSCredentialsProvider getCrossAccountCredentialsIfPresent(Map<String, String> configOptions, String roleSessionName) {
        if (configOptions.containsKey(CROSS_ACCOUNT_ROLE_ARN_CONFIG)) {
            logger.debug("Found cross-account role arn to assume.");
            AWSSecurityTokenService stsClient = (AWSSecurityTokenService)AWSSecurityTokenServiceAsyncClientBuilder.standard().build();
            AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(configOptions.get(CROSS_ACCOUNT_ROLE_ARN_CONFIG)).withRoleSessionName(roleSessionName);
            AssumeRoleResult assumeRoleResult = stsClient.assumeRole(assumeRoleRequest);
            Credentials credentials = assumeRoleResult.getCredentials();
            BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
            return new AWSStaticCredentialsProvider((AWSCredentials)basicSessionCredentials);
        }
        return DefaultAWSCredentialsProviderChain.getInstance();
    }
}

