/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import java.lang.reflect.Field;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.types.MetadataVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AthenaFederationIpcOption {
    private static final Logger logger = LoggerFactory.getLogger(AthenaFederationIpcOption.class);
    public static final IpcOption DEFAULT = AthenaFederationIpcOption.getIpcOption();

    private AthenaFederationIpcOption() {
    }

    private static IpcOption getIpcOption() {
        try {
            return new IpcOption(true, MetadataVersion.V4);
        }
        catch (NoSuchMethodError ex) {
            logger.warn("Exception while constructing IpcOption (this is expected on Spark 3.2.1 and older): {}", (Object)ex.toString());
            logger.info("Falling back to old way of constructing IpcOption for Arrow 2.0.0");
            try {
                IpcOption ipcOption = new IpcOption();
                Field writeLegacyIpcFormatField = IpcOption.class.getDeclaredField("write_legacy_ipc_format");
                Field metadataVersionField = IpcOption.class.getDeclaredField("metadataVersion");
                writeLegacyIpcFormatField.setBoolean(ipcOption, true);
                metadataVersionField.set(ipcOption, MetadataVersion.V4);
                return ipcOption;
            }
            catch (ReflectiveOperationException ex2) {
                throw new RuntimeException(ex2);
            }
        }
    }
}

