/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class FieldBuilder {
    private final String name;
    private final ArrowType type;
    private final boolean nullable;
    private final Map<String, Field> children = new LinkedHashMap<String, Field>();

    private FieldBuilder(String name, ArrowType type, boolean nullable) {
        this.name = name;
        this.type = type;
        this.nullable = nullable;
    }

    public static FieldBuilder newBuilder(String name, ArrowType type) {
        return new FieldBuilder(name, type, true);
    }

    public static FieldBuilder newBuilder(String name, ArrowType type, boolean nullable) {
        return new FieldBuilder(name, type, nullable);
    }

    public FieldBuilder addField(String fieldName, ArrowType type, List<Field> children) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)type), children));
        return this;
    }

    public FieldBuilder addField(String fieldName, ArrowType type, boolean nullable, List<Field> children) {
        this.children.put(fieldName, new Field(fieldName, new FieldType(nullable, type, null), children));
        return this;
    }

    public FieldBuilder addField(Field child) {
        this.children.put(child.getName(), child);
        return this;
    }

    public FieldBuilder addStringField(String fieldName) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.VARCHAR.getType()), null));
        return this;
    }

    public FieldBuilder addListField(String fieldName, ArrowType type) {
        Field baseField = new Field("", FieldType.nullable((ArrowType)type), null);
        Field field = new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.LIST.getType()), Collections.singletonList(baseField));
        this.children.put(fieldName, field);
        return this;
    }

    public FieldBuilder addIntField(String fieldName) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null));
        return this;
    }

    public FieldBuilder addFloat8Field(String fieldName) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.FLOAT8.getType()), null));
        return this;
    }

    public FieldBuilder addBigIntField(String fieldName) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), null));
        return this;
    }

    public FieldBuilder addBitField(String fieldName) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.BIT.getType()), null));
        return this;
    }

    public FieldBuilder addTinyIntField(String fieldName) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.TINYINT.getType()), null));
        return this;
    }

    public FieldBuilder addSmallIntField(String fieldName) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.SMALLINT.getType()), null));
        return this;
    }

    public FieldBuilder addFloat4Field(String fieldName) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.FLOAT4.getType()), null));
        return this;
    }

    public FieldBuilder addDecimalField(String fieldName, int precision, int scale) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)new ArrowType.Decimal(precision, scale)), null));
        return this;
    }

    public FieldBuilder addDateDayField(String fieldName) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.DATEDAY.getType()), null));
        return this;
    }

    public FieldBuilder addDateMilliField(String fieldName) {
        this.children.put(fieldName, new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.DATEMILLI.getType()), null));
        return this;
    }

    public Field getChild(String fieldName) {
        return this.children.get(fieldName);
    }

    public Field build() {
        return new Field(this.name, new FieldType(this.nullable, this.type, null), new ArrayList<Field>(this.children.values()));
    }
}

