/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.domain.spill.S3SpillLocation;
import com.amazonaws.athena.connector.lambda.security.AesGcmBlockCrypto;
import com.amazonaws.athena.connector.lambda.security.BlockCrypto;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.amazonaws.athena.connector.lambda.security.NoOpBlockCrypto;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3Object;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BlockSpillReader {
    private static final Logger logger = LoggerFactory.getLogger(S3BlockSpillReader.class);
    private final AmazonS3 amazonS3;
    private final BlockAllocator allocator;

    public S3BlockSpillReader(AmazonS3 amazonS3, BlockAllocator allocator) {
        this.amazonS3 = Objects.requireNonNull(amazonS3, "amazonS3 was null");
        this.allocator = Objects.requireNonNull(allocator, "allocator was null");
    }

    public Block read(S3SpillLocation spillLocation, EncryptionKey key, Schema schema) {
        S3Object fullObject = null;
        try {
            logger.debug("read: Started reading block from S3");
            fullObject = this.amazonS3.getObject(spillLocation.getBucket(), spillLocation.getKey());
            logger.debug("read: Completed reading block from S3");
            BlockCrypto blockCrypto = key != null ? new AesGcmBlockCrypto(this.allocator) : new NoOpBlockCrypto(this.allocator);
            Block block = blockCrypto.decrypt(key, ByteStreams.toByteArray((InputStream)fullObject.getObjectContent()), schema);
            logger.debug("read: Completed decrypting block of size.");
            Block block2 = block;
            return block2;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (fullObject != null) {
                try {
                    fullObject.close();
                }
                catch (IOException ex) {
                    logger.warn("read: Exception while closing S3 object", (Throwable)ex);
                }
            }
        }
    }

    public byte[] read(S3SpillLocation spillLocation, EncryptionKey key) {
        S3Object fullObject = null;
        try {
            logger.debug("read: Started reading block from S3");
            fullObject = this.amazonS3.getObject(spillLocation.getBucket(), spillLocation.getKey());
            logger.debug("read: Completed reading block from S3");
            BlockCrypto blockCrypto = key != null ? new AesGcmBlockCrypto(this.allocator) : new NoOpBlockCrypto(this.allocator);
            byte[] byArray = blockCrypto.decrypt(key, ByteStreams.toByteArray((InputStream)fullObject.getObjectContent()));
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (fullObject != null) {
                try {
                    fullObject.close();
                }
                catch (IOException ex) {
                    logger.warn("read: Exception while closing S3 object", (Throwable)ex);
                }
            }
        }
    }
}

