/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockWriter;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintEvaluator;

public class SimpleBlockWriter
implements BlockWriter {
    private final Block block;

    public SimpleBlockWriter(Block block) {
        this.block = block;
    }

    @Override
    public void writeRows(BlockWriter.RowWriter rowWriter) {
        int rows;
        int rowCount = this.block.getRowCount();
        try {
            rows = rowWriter.writeRows(this.block, rowCount);
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
        if (rows > 0) {
            this.block.setRowCount(rowCount + rows);
        }
    }

    @Override
    public ConstraintEvaluator getConstraintEvaluator() {
        return this.block.getConstraintEvaluator();
    }
}

