/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.BigIntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.BitExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.DateDayExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.DateMilliExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.DecimalExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.Extractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.Float4Extractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.Float8Extractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.IntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.SmallIntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.TinyIntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.VarBinaryExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.VarCharExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.BigIntFieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.BitFieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.DateDayFieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.DateMilliFieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.DecimalFieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriterFactory;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.Float4FieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.Float8FieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.IntFieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.SmallIntFieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.TinyIntFieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.VarBinaryFieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.VarCharFieldWriter;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratedRowWriter {
    private static final Logger logger = LoggerFactory.getLogger(GeneratedRowWriter.class);
    private final LinkedHashMap<String, Extractor> extractors = new LinkedHashMap();
    private final LinkedHashMap<String, FieldWriterFactory> fieldWriterFactories = new LinkedHashMap();
    private List<FieldWriter> fieldWriters = new ArrayList<FieldWriter>();
    private LinkedHashMap<String, ConstraintProjector> constraints = new LinkedHashMap();
    private Block block;

    private GeneratedRowWriter(RowWriterBuilder builder) {
        this.extractors.putAll(builder.extractors);
        this.fieldWriterFactories.putAll(builder.fieldWriterFactories);
        if (builder.constraints != null && builder.constraints.getSummary() != null) {
            for (Map.Entry<String, ValueSet> next : builder.constraints.getSummary().entrySet()) {
                this.constraints.put(next.getKey(), this.makeConstraintProjector(next.getValue()));
            }
        }
    }

    public static RowWriterBuilder newBuilder(Constraints constraints) {
        return new RowWriterBuilder(constraints);
    }

    public static RowWriterBuilder newBuilder() {
        return new RowWriterBuilder(new Constraints((Map<String, ValueSet>)ImmutableMap.of(), Collections.emptyList(), Collections.emptyList(), -1L));
    }

    public boolean writeRow(Block block, int rowNum, Object context) throws Exception {
        this.checkAndRecompile(block);
        boolean matched = true;
        for (FieldWriter next : this.fieldWriters) {
            matched &= next.write(context, rowNum);
        }
        return matched;
    }

    private ConstraintProjector makeConstraintProjector(ValueSet constraint) {
        return value -> constraint.containsValue(value);
    }

    private void checkAndRecompile(Block block) {
        if (this.block != block) {
            logger.info("recompile: Detected a new block, rebuilding field writers so they point to the correct Arrow vectors.");
            this.block = block;
            this.fieldWriters.clear();
            for (FieldVector vector : block.getFieldVectors()) {
                this.fieldWriters.add(this.makeFieldWriter(vector));
            }
        }
    }

    private FieldWriter makeFieldWriter(FieldVector vector) {
        Field field = vector.getField();
        String fieldName = field.getName();
        Types.MinorType fieldType = Types.getMinorTypeForArrowType((ArrowType)field.getType());
        Extractor extractor = this.extractors.get(fieldName);
        ConstraintProjector constraint = this.constraints.get(fieldName);
        FieldWriterFactory factory = this.fieldWriterFactories.get(fieldName);
        if (factory != null) {
            return factory.create(vector, extractor, constraint);
        }
        if (extractor == null) {
            throw new IllegalStateException("Missing extractor for field[" + fieldName + "]");
        }
        switch (fieldType) {
            case INT: {
                return new IntFieldWriter((IntExtractor)extractor, (IntVector)vector, constraint);
            }
            case BIGINT: {
                return new BigIntFieldWriter((BigIntExtractor)extractor, (BigIntVector)vector, constraint);
            }
            case DATEMILLI: {
                return new DateMilliFieldWriter((DateMilliExtractor)extractor, (DateMilliVector)vector, constraint);
            }
            case DATEDAY: {
                return new DateDayFieldWriter((DateDayExtractor)extractor, (DateDayVector)vector, constraint);
            }
            case TINYINT: {
                return new TinyIntFieldWriter((TinyIntExtractor)extractor, (TinyIntVector)vector, constraint);
            }
            case SMALLINT: {
                return new SmallIntFieldWriter((SmallIntExtractor)extractor, (SmallIntVector)vector, constraint);
            }
            case FLOAT4: {
                return new Float4FieldWriter((Float4Extractor)extractor, (Float4Vector)vector, constraint);
            }
            case FLOAT8: {
                return new Float8FieldWriter((Float8Extractor)extractor, (Float8Vector)vector, constraint);
            }
            case DECIMAL: {
                return new DecimalFieldWriter((DecimalExtractor)extractor, (DecimalVector)vector, constraint);
            }
            case BIT: {
                return new BitFieldWriter((BitExtractor)extractor, (BitVector)vector, constraint);
            }
            case VARCHAR: {
                return new VarCharFieldWriter((VarCharExtractor)extractor, (VarCharVector)vector, constraint);
            }
            case VARBINARY: {
                return new VarBinaryFieldWriter((VarBinaryExtractor)extractor, (VarBinaryVector)vector, constraint);
            }
        }
        throw new RuntimeException(fieldType + " is not supported");
    }

    public static class RowWriterBuilder {
        private final Constraints constraints;
        private final LinkedHashMap<String, Extractor> extractors = new LinkedHashMap();
        private final LinkedHashMap<String, FieldWriterFactory> fieldWriterFactories = new LinkedHashMap();

        private RowWriterBuilder(Constraints constraints) {
            this.constraints = constraints;
        }

        public RowWriterBuilder withExtractor(String fieldName, Extractor extractor) {
            this.extractors.put(fieldName, extractor);
            return this;
        }

        public RowWriterBuilder withFieldWriterFactory(String fieldName, FieldWriterFactory factory) {
            this.fieldWriterFactories.put(fieldName, factory);
            return this;
        }

        public GeneratedRowWriter build() {
            return new GeneratedRowWriter(this);
        }
    }
}

