/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.DecimalExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.holders.NullableDecimalHolder;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.arrow.vector.DecimalVector;

public class DecimalFieldWriter
implements FieldWriter {
    private final NullableDecimalHolder holder = new NullableDecimalHolder();
    private final DecimalExtractor extractor;
    private final DecimalVector vector;
    private final ConstraintApplier constraint;

    public DecimalFieldWriter(DecimalExtractor extractor, DecimalVector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : value.value) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        if (this.holder.isSet > 0) {
            BigDecimal dVal = this.holder.value.setScale(this.vector.getScale(), RoundingMode.HALF_UP);
            this.vector.setSafe(rowNum, dVal);
        } else {
            this.vector.setNull(rowNum);
        }
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableDecimalHolder var1);
    }
}

