/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.IntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.holders.NullableIntHolder;

public class IntFieldWriter
implements FieldWriter {
    private final NullableIntHolder holder = new NullableIntHolder();
    private final IntExtractor extractor;
    private final IntVector vector;
    private final ConstraintApplier constraint;

    public IntFieldWriter(IntExtractor extractor, IntVector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : Integer.valueOf(value.value)) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        this.vector.setSafe(rowNum, this.holder);
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableIntHolder var1);
    }
}

