/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.TinyIntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.holders.NullableTinyIntHolder;

public class TinyIntFieldWriter
implements FieldWriter {
    private final NullableTinyIntHolder holder = new NullableTinyIntHolder();
    private final TinyIntExtractor extractor;
    private final TinyIntVector vector;
    private final ConstraintApplier constraint;

    public TinyIntFieldWriter(TinyIntExtractor extractor, TinyIntVector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : Byte.valueOf(value.value)) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        this.vector.setSafe(rowNum, this.holder);
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableTinyIntHolder var1);
    }
}

