/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.VarCharExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.data.writers.holders.NullableVarCharHolder;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import com.google.common.base.Charsets;
import org.apache.arrow.vector.VarCharVector;

public class VarCharFieldWriter
implements FieldWriter {
    private final NullableVarCharHolder holder = new NullableVarCharHolder();
    private final VarCharExtractor extractor;
    private final VarCharVector vector;
    private final ConstraintApplier constraint;

    public VarCharFieldWriter(VarCharExtractor extractor, VarCharVector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : value.value) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        if (this.holder.isSet > 0) {
            this.vector.setSafe(rowNum, this.holder.value.getBytes(Charsets.UTF_8));
        } else {
            this.vector.setNull(rowNum);
        }
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableVarCharHolder var1);
    }
}

