/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain;

import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.beans.Transient;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Split {
    private final SpillLocation spillLocation;
    private final EncryptionKey encryptionKey;
    private final Map<String, String> properties;

    @JsonCreator
    public Split(@JsonProperty(value="spillLocation") SpillLocation spillLocation, @JsonProperty(value="encryptionKey") EncryptionKey encryptionKey, @JsonProperty(value="properties") Map<String, String> properties) {
        Objects.requireNonNull(properties, "properties is null");
        this.spillLocation = spillLocation;
        this.encryptionKey = encryptionKey;
        this.properties = Collections.unmodifiableMap(properties);
    }

    private Split(Builder builder) {
        this.properties = Collections.unmodifiableMap(builder.properties);
        this.spillLocation = builder.spillLocation;
        this.encryptionKey = builder.encryptionKey;
    }

    @Transient
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Transient
    public int getPropertyAsInt(String key) {
        return Integer.parseInt(this.properties.get(key));
    }

    @Transient
    public long getPropertyAsLong(String key) {
        return Long.parseLong(this.properties.get(key));
    }

    @Transient
    public double getPropertyAsDouble(String key) {
        return Double.parseDouble(this.properties.get(key));
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty
    public SpillLocation getSpillLocation() {
        return this.spillLocation;
    }

    @JsonProperty
    public EncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    @Transient
    public static Builder newBuilder(SpillLocation spillLocation, EncryptionKey encryptionKey) {
        return new Builder().withSpillLocation(spillLocation).withEncryptionKey(encryptionKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Split split = (Split)o;
        return Objects.equals(this.spillLocation, split.spillLocation) && Objects.equals(this.encryptionKey, split.encryptionKey) && Objects.equals(this.getProperties(), split.getProperties());
    }

    public int hashCode() {
        return Objects.hash(this.spillLocation, this.encryptionKey, this.getProperties());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("spillLocation", (Object)this.spillLocation).add("encryptionKey", (Object)"<hidden>").add("properties", this.properties).toString();
    }

    public static class Builder {
        private final Map<String, String> properties = new HashMap<String, String>();
        private SpillLocation spillLocation;
        private EncryptionKey encryptionKey;

        private Builder() {
        }

        public Builder add(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder withSpillLocation(SpillLocation val) {
            this.spillLocation = val;
            return this;
        }

        public Builder withEncryptionKey(EncryptionKey key) {
            this.encryptionKey = key;
            return this;
        }

        public Split build() {
            return new Split(this);
        }
    }
}

