/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.records;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.records.RecordRequestType;
import com.amazonaws.athena.connector.lambda.records.RecordResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.beans.Transient;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Schema;

public class ReadRecordsResponse
extends RecordResponse {
    private final Block records;

    @JsonCreator
    public ReadRecordsResponse(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="records") Block records) {
        super(RecordRequestType.READ_RECORDS, catalogName);
        Objects.requireNonNull(records, "records is null");
        this.records = records;
    }

    @Transient
    public Schema getSchema() {
        return this.records.getSchema();
    }

    @JsonProperty
    public Block getRecords() {
        return this.records;
    }

    @Transient
    public int getRecordCount() {
        return this.records.getRowCount();
    }

    @Override
    public void close() throws Exception {
        this.records.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("records", (Object)this.records).add("requestType", (Object)this.getRequestType()).add("catalogName", (Object)this.getCatalogName()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadRecordsResponse that = (ReadRecordsResponse)o;
        return com.google.common.base.Objects.equal((Object)this.records, (Object)that.records) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.records, this.getRequestType(), this.getCatalogName()});
    }
}

