/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorRegistry;
import com.amazonaws.athena.connector.lambda.data.RecordBatchSerDe;
import com.amazonaws.athena.connector.lambda.data.SchemaSerDe;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;

@Deprecated
public class BlockDeserializer
extends StdDeserializer<Block> {
    private final BlockAllocatorRegistry allocatorRegistry;
    private final BlockAllocator allocator;
    private final SchemaSerDe schemaSerDe = new SchemaSerDe();
    private final RecordBatchSerDe recordBatchSerDe;

    public BlockDeserializer(BlockAllocator allocator) {
        super(Block.class);
        this.recordBatchSerDe = new RecordBatchSerDe(allocator);
        this.allocator = allocator;
        this.allocatorRegistry = null;
    }

    public BlockDeserializer(BlockAllocatorRegistry allocatorRegistry) {
        super(Block.class);
        this.allocator = null;
        this.recordBatchSerDe = null;
        this.allocatorRegistry = allocatorRegistry;
    }

    public Block deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String allocatorId = node.get("aId").asText();
        byte[] schemaBytes = node.get("schema").binaryValue();
        byte[] batchBytes = node.get("records").binaryValue();
        Schema schema = this.schemaSerDe.deserialize(new ByteArrayInputStream(schemaBytes));
        Block block = this.getOrCreateAllocator(allocatorId).createBlock(schema);
        if (batchBytes.length > 0) {
            ArrowRecordBatch batch = this.deserializeBatch(allocatorId, batchBytes);
            block.loadRecordBatch(batch);
        }
        return block;
    }

    private ArrowRecordBatch deserializeBatch(String allocatorId, byte[] batchBytes) throws IOException {
        return this.getOrCreateBatchSerde(allocatorId).deserialize(batchBytes);
    }

    private RecordBatchSerDe getOrCreateBatchSerde(String allocatorId) {
        if (this.recordBatchSerDe != null) {
            return this.recordBatchSerDe;
        }
        return new RecordBatchSerDe(this.getOrCreateAllocator(allocatorId));
    }

    private BlockAllocator getOrCreateAllocator(String allocatorId) {
        if (this.allocator != null) {
            return this.allocator;
        }
        return this.allocatorRegistry.getOrCreateAllocator(allocatorId);
    }
}

