/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.request.PingRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.serde.FederatedIdentitySerDe;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

public final class PingRequestSerDe {
    private static final String IDENTITY_FIELD = "identity";
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String QUERY_ID_FIELD = "queryId";

    private PingRequestSerDe() {
    }

    public static class Deserializer
    extends TypedDeserializer<FederationRequest> {
        private final FederatedIdentitySerDe.Deserializer identityDeserializer;

        public Deserializer(FederatedIdentitySerDe.Deserializer identityDeserializer) {
            super(FederationRequest.class, PingRequest.class);
            this.identityDeserializer = Objects.requireNonNull(identityDeserializer, "identityDeserializer is null");
        }

        @Override
        public FederationRequest deserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.validateObjectStart(jparser.getCurrentToken());
            return (FederationRequest)this.doDeserialize(jparser, ctxt);
        }

        @Override
        protected FederationRequest doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, PingRequestSerDe.IDENTITY_FIELD);
            FederatedIdentity identity = this.identityDeserializer.deserialize(jparser, ctxt);
            String catalogName = this.getNextStringField(jparser, PingRequestSerDe.CATALOG_NAME_FIELD);
            String queryId = this.getNextStringField(jparser, PingRequestSerDe.QUERY_ID_FIELD);
            return new PingRequest(identity, catalogName, queryId);
        }
    }

    public static class Serializer
    extends TypedSerializer<FederationRequest> {
        private final FederatedIdentitySerDe.Serializer identitySerializer;

        public Serializer(FederatedIdentitySerDe.Serializer identitySerializer) {
            super(FederationRequest.class, PingRequest.class);
            this.identitySerializer = Objects.requireNonNull(identitySerializer, "identitySerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationRequest federationRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            PingRequest pingRequest = (PingRequest)federationRequest;
            jgen.writeFieldName(PingRequestSerDe.IDENTITY_FIELD);
            this.identitySerializer.serialize(pingRequest.getIdentity(), jgen, provider);
            jgen.writeStringField(PingRequestSerDe.CATALOG_NAME_FIELD, pingRequest.getCatalogName());
            jgen.writeStringField(PingRequestSerDe.QUERY_ID_FIELD, pingRequest.getQueryId());
        }
    }
}

