/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.GetTableResponse;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.TableNameSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.arrow.vector.types.pojo.Schema;

public final class GetTableResponseSerDe {
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String TABLE_NAME_FIELD = "tableName";
    private static final String SCHEMA_FIELD = "schema";
    private static final String PARTITION_COLUMNS_FIELD = "partitionColumns";

    private GetTableResponseSerDe() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationResponse> {
        private final TableNameSerDe.Deserializer tableNameDeserializer;
        private final VersionedSerDe.Deserializer<Schema> schemaDeserializer;

        public Deserializer(TableNameSerDe.Deserializer tableNameDeserializer, VersionedSerDe.Deserializer<Schema> schemaDeserializer) {
            super(FederationResponse.class, GetTableResponse.class);
            this.tableNameDeserializer = Objects.requireNonNull(tableNameDeserializer, "tableNameDeserializer is null");
            this.schemaDeserializer = Objects.requireNonNull(schemaDeserializer, "schemaDeserializer is null");
        }

        @Override
        protected FederationResponse doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String catalogName = this.getNextStringField(jparser, GetTableResponseSerDe.CATALOG_NAME_FIELD);
            this.assertFieldName(jparser, GetTableResponseSerDe.TABLE_NAME_FIELD);
            TableName tableName = (TableName)this.tableNameDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, GetTableResponseSerDe.SCHEMA_FIELD);
            Schema schema = this.schemaDeserializer.deserialize(jparser, ctxt);
            ImmutableSet.Builder partitionColsSet = ImmutableSet.builder();
            partitionColsSet.addAll(this.getNextStringArray(jparser, GetTableResponseSerDe.PARTITION_COLUMNS_FIELD));
            return new GetTableResponse(catalogName, tableName, schema, (Set<String>)partitionColsSet.build());
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationResponse> {
        private final TableNameSerDe.Serializer tableNameSerializer;
        private final VersionedSerDe.Serializer<Schema> schemaSerializer;

        public Serializer(TableNameSerDe.Serializer tableNameSerializer, VersionedSerDe.Serializer<Schema> schemaSerializer) {
            super(FederationResponse.class, GetTableResponse.class);
            this.tableNameSerializer = Objects.requireNonNull(tableNameSerializer, "tableNameSerializer is null");
            this.schemaSerializer = Objects.requireNonNull(schemaSerializer, "schemaSerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationResponse federationResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            GetTableResponse getTableResponse = (GetTableResponse)federationResponse;
            jgen.writeStringField(GetTableResponseSerDe.CATALOG_NAME_FIELD, getTableResponse.getCatalogName());
            jgen.writeFieldName(GetTableResponseSerDe.TABLE_NAME_FIELD);
            this.tableNameSerializer.serialize(getTableResponse.getTableName(), jgen, provider);
            jgen.writeFieldName(GetTableResponseSerDe.SCHEMA_FIELD);
            this.schemaSerializer.serialize(getTableResponse.getSchema(), jgen, provider);
            this.writeStringArray(jgen, GetTableResponseSerDe.PARTITION_COLUMNS_FIELD, getTableResponse.getPartitionColumns());
        }
    }
}

