/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v4;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.domain.predicate.expression.ConstantExpression;
import com.amazonaws.athena.connector.lambda.domain.predicate.expression.FederationExpression;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ArrowTypeSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.ArrowType;

public final class ConstantExpressionSerDeV4 {
    private static final String VALUE_BLOCK_FIELD = "valueBlock";
    private static final String TYPE_FIELD = "type";

    private ConstantExpressionSerDeV4() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationExpression>
    implements VersionedSerDe.Deserializer<FederationExpression> {
        private final VersionedSerDe.Deserializer<Block> blockDeserializer;
        private final ArrowTypeSerDe.Deserializer arrowTypeDeserializer;

        public Deserializer(VersionedSerDe.Deserializer<Block> blockDeserializer, ArrowTypeSerDe.Deserializer arrowTypeDeserializer) {
            super(FederationExpression.class, ConstantExpression.class);
            this.blockDeserializer = Objects.requireNonNull(blockDeserializer, "blockSerDe is null");
            this.arrowTypeDeserializer = Objects.requireNonNull(arrowTypeDeserializer, "arrowTypeDeserializer is null");
        }

        @Override
        protected FederationExpression doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, ConstantExpressionSerDeV4.VALUE_BLOCK_FIELD);
            Block valueBlock = this.blockDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, ConstantExpressionSerDeV4.TYPE_FIELD);
            ArrowType type = (ArrowType)this.arrowTypeDeserializer.deserialize(jparser, ctxt);
            return new ConstantExpression(valueBlock, type);
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationExpression>
    implements VersionedSerDe.Serializer<FederationExpression> {
        private final VersionedSerDe.Serializer<Block> blockSerializer;
        private final ArrowTypeSerDe.Serializer arrowTypeSerializer;

        public Serializer(VersionedSerDe.Serializer<Block> blockSerializer, ArrowTypeSerDe.Serializer arrowTypeSerializer) {
            super(FederationExpression.class, ConstantExpression.class);
            this.blockSerializer = Objects.requireNonNull(blockSerializer, "blockSerDe is null");
            this.arrowTypeSerializer = Objects.requireNonNull(arrowTypeSerializer, "arrowTypeSerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationExpression federationExpression, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            ConstantExpression constantExpression = (ConstantExpression)federationExpression;
            jgen.writeFieldName(ConstantExpressionSerDeV4.VALUE_BLOCK_FIELD);
            this.blockSerializer.serialize(constantExpression.getValues(), jgen, provider);
            jgen.writeFieldName(ConstantExpressionSerDeV4.TYPE_FIELD);
            this.arrowTypeSerializer.serialize(constantExpression.getType(), jgen, provider);
        }
    }
}

