/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v4;

import com.amazonaws.athena.connector.lambda.domain.predicate.OrderByField;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class OrderByFieldSerDeV4 {
    private static final String COLUMN_NAME_FIELD = "columnName";
    private static final String DIRECTION_FIELD = "direction";

    private OrderByFieldSerDeV4() {
    }

    public static final class Deserializer
    extends BaseDeserializer<OrderByField>
    implements VersionedSerDe.Deserializer<OrderByField> {
        public Deserializer() {
            super(OrderByField.class);
        }

        @Override
        public OrderByField doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            OrderByField.Direction directionEnum;
            String direction;
            String columnName = this.getNextStringField(jparser, OrderByFieldSerDeV4.COLUMN_NAME_FIELD);
            switch (direction = this.getNextStringField(jparser, OrderByFieldSerDeV4.DIRECTION_FIELD)) {
                case "ASC_NULLS_FIRST": {
                    directionEnum = OrderByField.Direction.ASC_NULLS_FIRST;
                    break;
                }
                case "ASC_NULLS_LAST": {
                    directionEnum = OrderByField.Direction.ASC_NULLS_LAST;
                    break;
                }
                case "DESC_NULLS_FIRST": {
                    directionEnum = OrderByField.Direction.DESC_NULLS_FIRST;
                    break;
                }
                case "DESC_NULLS_LAST": {
                    directionEnum = OrderByField.Direction.DESC_NULLS_LAST;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + direction);
                }
            }
            return new OrderByField(columnName, directionEnum);
        }
    }

    public static final class Serializer
    extends BaseSerializer<OrderByField>
    implements VersionedSerDe.Serializer<OrderByField> {
        public Serializer() {
            super(OrderByField.class);
        }

        @Override
        public void doSerialize(OrderByField orderByField, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStringField(OrderByFieldSerDeV4.COLUMN_NAME_FIELD, orderByField.getColumnName());
            jgen.writeStringField(OrderByFieldSerDeV4.DIRECTION_FIELD, orderByField.getDirection().name());
        }
    }
}

