/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v4;

import com.amazonaws.athena.connector.lambda.domain.predicate.expression.FederationExpression;
import com.amazonaws.athena.connector.lambda.domain.predicate.expression.VariableExpression;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ArrowTypeSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.ArrowType;

public final class VariableExpressionSerDeV4 {
    private static final String COLUMN_NAME_FIELD = "columnName";
    private static final String TYPE_FIELD = "type";

    private VariableExpressionSerDeV4() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationExpression>
    implements VersionedSerDe.Deserializer<FederationExpression> {
        private final ArrowTypeSerDe.Deserializer arrowTypeDeserializer;

        public Deserializer(ArrowTypeSerDe.Deserializer arrowTypeDeserializer) {
            super(FederationExpression.class, VariableExpression.class);
            this.arrowTypeDeserializer = Objects.requireNonNull(arrowTypeDeserializer, "arrowTypeDeserializer is null");
        }

        @Override
        protected FederationExpression doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String columnName = this.getNextStringField(jparser, VariableExpressionSerDeV4.COLUMN_NAME_FIELD);
            this.assertFieldName(jparser, VariableExpressionSerDeV4.TYPE_FIELD);
            ArrowType type = (ArrowType)this.arrowTypeDeserializer.deserialize(jparser, ctxt);
            return new VariableExpression(columnName, type);
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationExpression>
    implements VersionedSerDe.Serializer<FederationExpression> {
        private final ArrowTypeSerDe.Serializer arrowTypeSerializer;

        public Serializer(ArrowTypeSerDe.Serializer arrowTypeSerializer) {
            super(FederationExpression.class, VariableExpression.class);
            this.arrowTypeSerializer = Objects.requireNonNull(arrowTypeSerializer, "arrowTypeSerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationExpression federationExpression, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            VariableExpression variableExpression = (VariableExpression)federationExpression;
            jgen.writeStringField(VariableExpressionSerDeV4.COLUMN_NAME_FIELD, variableExpression.getColumnName());
            jgen.writeFieldName(VariableExpressionSerDeV4.TYPE_FIELD);
            this.arrowTypeSerializer.serialize(variableExpression.getType(), jgen, provider);
        }
    }
}

