/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class ArrowSchemaUtils {
    public static Field remapArrowTypesWithinField(Field inputField, Function<ArrowType, ArrowType> arrowTypeMapper) {
        List updatedChildren = inputField.getChildren().stream().map(f -> ArrowSchemaUtils.remapArrowTypesWithinField(f, arrowTypeMapper)).collect(Collectors.toList());
        ArrowType newArrowType = arrowTypeMapper.apply(inputField.getType());
        FieldType oldFieldType = inputField.getFieldType();
        FieldType newFieldType = new FieldType(oldFieldType.isNullable(), newArrowType, oldFieldType.getDictionary(), oldFieldType.getMetadata());
        return new Field(inputField.getName(), newFieldType, updatedChildren);
    }

    private ArrowSchemaUtils() {
    }
}

