/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.OutOfMemoryException;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockAllocatorImpl
implements BlockAllocator {
    private static final Logger logger = LoggerFactory.getLogger(BlockAllocatorImpl.class);
    private final String id;
    private final BufferAllocator rootAllocator;
    private final boolean ownRootAllocator;
    private final List<Block> blocks = new ArrayList<Block>();
    private final List<ArrowRecordBatch> recordBatches = new ArrayList<ArrowRecordBatch>();
    private final List<ArrowBuf> arrowBufs = new ArrayList<ArrowBuf>();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public BlockAllocatorImpl() {
        this(UUID.randomUUID().toString(), Integer.MAX_VALUE);
    }

    public BlockAllocatorImpl(RootAllocator rootAllocator) {
        this(UUID.randomUUID().toString(), rootAllocator);
    }

    public BlockAllocatorImpl(String id) {
        this(id, Integer.MAX_VALUE);
    }

    public BlockAllocatorImpl(String id, RootAllocator rootAllocator) {
        this.rootAllocator = rootAllocator;
        this.ownRootAllocator = false;
        this.id = id;
    }

    public BlockAllocatorImpl(String id, long memoryLimit) {
        this.rootAllocator = new RootAllocator(memoryLimit);
        this.ownRootAllocator = true;
        this.id = id;
    }

    @Override
    public synchronized Block createBlock(Schema schema) {
        Block block = null;
        VectorSchemaRoot vectorSchemaRoot = null;
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        try {
            for (Field next : schema.getFields()) {
                vectors.add(next.createVector(this.rootAllocator));
            }
            vectorSchemaRoot = new VectorSchemaRoot(schema, vectors, 0);
            block = new Block(this.id, schema, vectorSchemaRoot);
            this.blocks.add(block);
        }
        catch (Exception ex) {
            if (block != null) {
                try {
                    block.close();
                }
                catch (Exception ex2) {
                    logger.error("createBlock: error while closing block during previous error.", (Throwable)ex2);
                }
            }
            if (vectorSchemaRoot != null) {
                vectorSchemaRoot.close();
            }
            for (FieldVector next : vectors) {
                next.close();
            }
            throw ex;
        }
        return block;
    }

    @Override
    public ArrowBuf createBuffer(int size) {
        ArrowBuf buffer = null;
        try {
            buffer = this.rootAllocator.buffer((long)size);
            this.arrowBufs.add(buffer);
            return buffer;
        }
        catch (Exception ex) {
            if (buffer != null) {
                buffer.close();
            }
            throw ex;
        }
    }

    @Override
    public synchronized ArrowRecordBatch registerBatch(BlockAllocator.BatchGenerator generator) {
        try {
            logger.debug("registerBatch: {}", (Object)this.recordBatches.size());
            ArrowRecordBatch batch = generator.generate(this.getRawAllocator());
            this.recordBatches.add(batch);
            return batch;
        }
        catch (OutOfMemoryException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected synchronized BufferAllocator getRawAllocator() {
        logger.debug("getRawAllocator: enter");
        return this.rootAllocator;
    }

    @VisibleForTesting
    protected synchronized void closeBlocks() {
        logger.debug("closeBlocks: {}", (Object)this.blocks.size());
        for (Block next : this.blocks) {
            try {
                next.close();
            }
            catch (Exception ex) {
                logger.warn("closeBlocks: Error closing block", (Throwable)ex);
            }
        }
        this.blocks.clear();
    }

    @VisibleForTesting
    protected synchronized void closeBuffers() {
        logger.debug("closeBuffers: {}", (Object)this.arrowBufs.size());
        for (ArrowBuf next : this.arrowBufs) {
            try {
                next.close();
            }
            catch (Exception ex) {
                logger.warn("closeBuffers: Error closing buffer", (Throwable)ex);
            }
        }
        this.arrowBufs.clear();
    }

    @VisibleForTesting
    protected synchronized void closeBatches() {
        logger.debug("closeBatches: {}", (Object)this.recordBatches.size());
        for (ArrowRecordBatch next : this.recordBatches) {
            try {
                next.close();
            }
            catch (Exception ex) {
                logger.warn("closeBatches: Error closing batch", (Throwable)ex);
            }
        }
        this.recordBatches.clear();
    }

    @Override
    public long getUsage() {
        return this.rootAllocator.getAllocatedMemory();
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed.get()) {
            this.isClosed.set(true);
            this.closeBatches();
            this.closeBlocks();
            this.closeBuffers();
            if (this.ownRootAllocator) {
                this.rootAllocator.close();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }
}

