/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.projectors;

import com.amazonaws.athena.connector.lambda.data.projectors.ArrowValueProjectorImpl;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class StructArrowValueProjector
extends ArrowValueProjectorImpl {
    private final Map<String, ArrowValueProjectorImpl.Projection> projectionsMap;
    private final FieldReader structReader;

    public StructArrowValueProjector(FieldReader structReader) {
        this.structReader = Objects.requireNonNull(structReader, "structReader is null");
        ImmutableMap.Builder projectionMapBuilder = ImmutableMap.builder();
        List children = structReader.getField().getChildren();
        for (Field child : children) {
            String childName = child.getName();
            Types.MinorType minorType = Types.getMinorTypeForArrowType((ArrowType)child.getType());
            ArrowValueProjectorImpl.Projection projection = this.createValueProjection(minorType);
            projectionMapBuilder.put((Object)childName, (Object)projection);
        }
        this.projectionsMap = projectionMapBuilder.build();
    }

    @Override
    public Object project(int pos) {
        this.structReader.setPosition(pos);
        if (!this.structReader.isSet()) {
            return null;
        }
        return this.doProject();
    }

    protected Map<String, Object> doProject() {
        List fields = this.structReader.getField().getChildren();
        HashMap<String, Object> nameToValues = new HashMap<String, Object>();
        for (Field child : fields) {
            String childName = child.getName();
            FieldReader subReader = this.structReader.reader(childName);
            ArrowValueProjectorImpl.Projection childProjection = this.projectionsMap.get(childName);
            nameToValues.put(child.getName(), childProjection.doProjection(subReader));
        }
        return nameToValues;
    }
}

