/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.writers.fieldwriters;

import com.amazonaws.athena.connector.lambda.data.writers.extractors.Float8Extractor;
import com.amazonaws.athena.connector.lambda.data.writers.fieldwriters.FieldWriter;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.holders.NullableFloat8Holder;

public class Float8FieldWriter
implements FieldWriter {
    private final NullableFloat8Holder holder = new NullableFloat8Holder();
    private final Float8Extractor extractor;
    private final Float8Vector vector;
    private final ConstraintApplier constraint;

    public Float8FieldWriter(Float8Extractor extractor, Float8Vector vector, ConstraintProjector rawConstraint) {
        this.extractor = extractor;
        this.vector = vector;
        this.constraint = rawConstraint != null ? value -> rawConstraint.apply(value.isSet == 0 ? null : Double.valueOf(value.value)) : value -> true;
    }

    @Override
    public boolean write(Object context, int rowNum) throws Exception {
        this.extractor.extract(context, this.holder);
        this.vector.setSafe(rowNum, this.holder);
        return this.constraint.apply(this.holder);
    }

    private static interface ConstraintApplier {
        public boolean apply(NullableFloat8Holder var1);
    }
}

