/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class MarkerFactory
implements AutoCloseable {
    private final BlockAllocator allocator;
    private final Map<ArrowType, Block> sharedMarkerBlocks = new HashMap<ArrowType, Block>();
    private final Map<ArrowType, Integer> markerLeases = new HashMap<ArrowType, Integer>();

    public MarkerFactory(BlockAllocator allocator) {
        this.allocator = allocator;
    }

    public Marker createNullable(ArrowType type, Object value, Marker.Bound bound) {
        BlockLease lease = this.getOrCreateBlock(type);
        if (value != null) {
            BlockUtils.setValue(lease.getBlock().getFieldVector("col1"), lease.getPos(), value);
        }
        return new SharedBlockMarker(this, lease.getBlock(), lease.getPos(), bound, value == null);
    }

    public Marker create(ArrowType type, Object value, Marker.Bound bound) {
        BlockLease lease = this.getOrCreateBlock(type);
        BlockUtils.setValue(lease.getBlock().getFieldVector("col1"), lease.getPos(), value);
        return new SharedBlockMarker(this, lease.getBlock(), lease.getPos(), bound, false);
    }

    public Marker create(ArrowType type, Marker.Bound bound) {
        BlockLease lease = this.getOrCreateBlock(type);
        return new SharedBlockMarker(this, lease.getBlock(), lease.getPos(), bound, true);
    }

    private synchronized BlockLease getOrCreateBlock(ArrowType type) {
        Block sharedBlock = this.sharedMarkerBlocks.get(type);
        Integer leaseNumber = this.markerLeases.get(type);
        if (sharedBlock == null) {
            sharedBlock = BlockUtils.newEmptyBlock(this.allocator, "col1", type);
            this.sharedMarkerBlocks.put(type, sharedBlock);
            leaseNumber = 0;
        }
        leaseNumber = leaseNumber + 1;
        this.markerLeases.put(type, leaseNumber);
        BlockLease lease = new BlockLease(sharedBlock, leaseNumber - 1);
        sharedBlock.setRowCount(leaseNumber);
        return lease;
    }

    private synchronized void returnBlockLease(ArrowType type, int pos) {
        Block sharedBlock = this.sharedMarkerBlocks.get(type);
        Integer leaseNumber = this.markerLeases.get(type);
        if (sharedBlock != null && leaseNumber > 0 && leaseNumber == pos + 1) {
            this.markerLeases.put(type, leaseNumber - 1);
        }
    }

    @Override
    public void close() throws Exception {
        for (Block next : this.sharedMarkerBlocks.values()) {
            next.close();
        }
        this.sharedMarkerBlocks.clear();
        this.markerLeases.clear();
    }

    public class SharedBlockMarker
    extends Marker {
        private final MarkerFactory factory;
        private final int valuePosition;

        public SharedBlockMarker(MarkerFactory factory, Block block, int valuePosition, Marker.Bound bound, boolean nullValue) {
            super(block, valuePosition, bound, nullValue);
            this.factory = factory;
            this.valuePosition = valuePosition;
        }

        @Override
        public void close() throws Exception {
            this.factory.returnBlockLease(this.getType(), this.valuePosition);
        }
    }

    private static class BlockLease {
        private final Block block;
        private final int pos;

        public BlockLease(Block block, int pos) {
            this.block = block;
            this.pos = pos;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

