/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate.expression;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.domain.predicate.expression.FederationExpression;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class ConstantExpression
extends FederationExpression {
    public static final String DEFAULT_CONSTANT_EXPRESSION_BLOCK_NAME = "col1";
    private final Block valueBlock;

    public ConstantExpression(@JsonProperty(value="valueBlock") @Nullable Block valueBlock, @JsonProperty(value="type") ArrowType type) {
        super(type);
        this.valueBlock = valueBlock;
    }

    @Nullable
    @JsonProperty(value="valueBlock")
    public Block getValues() {
        return this.valueBlock;
    }

    @Override
    public List<? extends FederationExpression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.valueBlock, this.getType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantExpression that = (ConstantExpression)o;
        return Objects.equals(this.valueBlock, that.valueBlock) && Objects.equals(this.getType(), that.getType());
    }

    @Override
    public String toString() {
        return this.valueBlock + "::" + this.getType();
    }
}

