/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate.functions;

import com.amazonaws.athena.connector.lambda.domain.predicate.functions.FunctionName;
import com.amazonaws.athena.connector.lambda.domain.predicate.functions.OperatorType;

public enum StandardFunctions {
    AND_FUNCTION_NAME(new FunctionName("$and"), OperatorType.VARARG),
    OR_FUNCTION_NAME(new FunctionName("$or"), OperatorType.VARARG),
    NOT_FUNCTION_NAME(new FunctionName("$not"), OperatorType.UNARY),
    IS_NULL_FUNCTION_NAME(new FunctionName("$is_null"), OperatorType.UNARY),
    NULLIF_FUNCTION_NAME(new FunctionName("$nullif"), OperatorType.BINARY),
    EQUAL_OPERATOR_FUNCTION_NAME(new FunctionName("$equal"), OperatorType.BINARY),
    NOT_EQUAL_OPERATOR_FUNCTION_NAME(new FunctionName("$not_equal"), OperatorType.BINARY),
    LESS_THAN_OPERATOR_FUNCTION_NAME(new FunctionName("$less_than"), OperatorType.BINARY),
    LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME(new FunctionName("$less_than_or_equal"), OperatorType.BINARY),
    GREATER_THAN_OPERATOR_FUNCTION_NAME(new FunctionName("$greater_than"), OperatorType.BINARY),
    GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME(new FunctionName("$greater_than_or_equal"), OperatorType.BINARY),
    IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME(new FunctionName("$is_distinct_from"), OperatorType.BINARY),
    ADD_FUNCTION_NAME(new FunctionName("$add"), OperatorType.BINARY),
    SUBTRACT_FUNCTION_NAME(new FunctionName("$subtract"), OperatorType.BINARY),
    MULTIPLY_FUNCTION_NAME(new FunctionName("$multiply"), OperatorType.BINARY),
    DIVIDE_FUNCTION_NAME(new FunctionName("$divide"), OperatorType.BINARY),
    MODULUS_FUNCTION_NAME(new FunctionName("$modulus"), OperatorType.BINARY),
    NEGATE_FUNCTION_NAME(new FunctionName("$negate"), OperatorType.UNARY),
    LIKE_PATTERN_FUNCTION_NAME(new FunctionName("$like_pattern"), OperatorType.BINARY),
    IN_PREDICATE_FUNCTION_NAME(new FunctionName("$in"), OperatorType.BINARY),
    ARRAY_CONSTRUCTOR_FUNCTION_NAME(new FunctionName("$array"));

    final FunctionName functionName;
    final OperatorType operatorType;

    private StandardFunctions(FunctionName functionName) {
        this.functionName = functionName;
        this.operatorType = OperatorType.VARARG;
    }

    private StandardFunctions(FunctionName functionName, OperatorType operatorType) {
        this.functionName = functionName;
        this.operatorType = operatorType;
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public static StandardFunctions fromFunctionName(FunctionName functionName) {
        for (StandardFunctions function : StandardFunctions.values()) {
            if (!function.getFunctionName().equals(functionName)) continue;
            return function;
        }
        return null;
    }
}

