/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.spill;

import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class S3SpillLocation
implements SpillLocation {
    private static final String SEPARATOR = "/";
    private final String bucket;
    private final String key;
    private final boolean directory;

    @JsonCreator
    public S3SpillLocation(@JsonProperty(value="bucket") String bucket, @JsonProperty(value="key") String key, @JsonProperty(value="directory") boolean directory) {
        this.bucket = bucket;
        this.key = key;
        this.directory = directory;
    }

    @JsonProperty
    public String getBucket() {
        return this.bucket;
    }

    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    public boolean isDirectory() {
        return this.directory;
    }

    public String toString() {
        return "S3SpillLocation{bucket='" + this.bucket + '\'' + ", key='" + this.key + '\'' + ", directory=" + this.directory + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3SpillLocation that = (S3SpillLocation)o;
        return this.isDirectory() == that.isDirectory() && Objects.equals(this.getBucket(), that.getBucket()) && Objects.equals(this.getKey(), that.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.getBucket(), this.getKey(), this.isDirectory());
    }

    public static class Builder {
        private String bucket;
        private String prefix;
        private String queryId;
        private String splitId;
        private boolean isDirectory = true;

        private Builder() {
        }

        public Builder withBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withIsDirectory(boolean isDirectory) {
            this.isDirectory = isDirectory;
            return this;
        }

        public Builder withQueryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public Builder withSplitId(String splitId) {
            this.splitId = splitId;
            return this;
        }

        public S3SpillLocation build() {
            String key = this.prefix + S3SpillLocation.SEPARATOR + this.queryId + S3SpillLocation.SEPARATOR + this.splitId;
            return new S3SpillLocation(this.bucket, key, true);
        }
    }
}

