/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.handlers;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.handlers.MetadataHandler;
import com.amazonaws.athena.connector.lambda.metadata.GetTableResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesResponse;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.metadata.glue.GlueFieldLexer;
import com.amazonaws.athena.connector.lambda.security.EncryptionKeyFactory;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.glue.AWSGlue;
import com.amazonaws.services.glue.AWSGlueClientBuilder;
import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTableResult;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlueMetadataHandler
extends MetadataHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlueMetadataHandler.class);
    protected static final int GET_TABLES_REQUEST_MAX_RESULTS = 100;
    private static final String DISABLE_GLUE = "disable_glue";
    private static final String CATALOG_NAME_ENV_OVERRIDE = "glue_catalog";
    private static final int CONNECT_TIMEOUT = 250;
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)",").trimResults().withKeyValueSeparator("=");
    private static final Pattern TABLE_ARN_REGEX = Pattern.compile("^arn:(?:aws|aws-cn|aws-us-gov):[a-z]+:[a-z1-9-]+:[0-9]{12}:table\\/(.+)$");
    private static final String FUNCTION_ARN_REGEX = "arn:aws[a-zA-Z-]*?:lambda:[a-zA-Z0-9-]+:(\\d{12}):function:[a-zA-Z0-9-_]+";
    public static final String SOURCE_TABLE_PROPERTY = "sourceTable";
    public static final String COLUMN_NAME_MAPPING_PROPERTY = "columnMapping";
    public static final String DATETIME_FORMAT_MAPPING_PROPERTY = "datetimeFormatMapping";
    public static final String DATETIME_FORMAT_MAPPING_PROPERTY_NORMALIZED = "datetimeFormatMappingNormalized";
    public static final String VIEW_METADATA_FIELD = "_view_template";
    public static final String GLUE_TABLE_CONTAINS_PREVIOUSLY_UNSUPPORTED_TYPE = "glueTableContainsPreviouslyUnsupportedType";
    private final AWSGlue awsGlue;

    public GlueMetadataHandler(String sourceType, Map<String, String> configOptions) {
        super(sourceType, configOptions);
        boolean disabled = configOptions.get(DISABLE_GLUE) != null && !"false".equalsIgnoreCase(configOptions.get(DISABLE_GLUE));
        this.awsGlue = disabled ? null : (AWSGlue)((AWSGlueClientBuilder)AWSGlueClientBuilder.standard().withClientConfiguration(new ClientConfiguration().withConnectionTimeout(250))).build();
    }

    public GlueMetadataHandler(AWSGlue awsGlue, String sourceType, Map<String, String> configOptions) {
        super(sourceType, configOptions);
        this.awsGlue = awsGlue;
    }

    @VisibleForTesting
    protected GlueMetadataHandler(AWSGlue awsGlue, EncryptionKeyFactory encryptionKeyFactory, AWSSecretsManager secretsManager, AmazonAthena athena, String sourceType, String spillBucket, String spillPrefix, Map<String, String> configOptions) {
        super(encryptionKeyFactory, secretsManager, athena, sourceType, spillBucket, spillPrefix, configOptions);
        this.awsGlue = awsGlue;
    }

    protected AWSGlue getAwsGlue() {
        return this.awsGlue;
    }

    protected String getCatalog(MetadataRequest request) {
        String override = (String)this.configOptions.get(CATALOG_NAME_ENV_OVERRIDE);
        if (override == null) {
            String functionArn;
            String functionOwner;
            if (request.getContext() != null && (functionOwner = (String)this.getFunctionOwner(functionArn = request.getContext().getInvokedFunctionArn()).orElse(null)) != null) {
                logger.debug("Function Owner: " + functionOwner);
                return functionOwner;
            }
            return request.getIdentity().getAccount();
        }
        return override;
    }

    @Override
    public ListSchemasResponse doListSchemaNames(BlockAllocator blockAllocator, ListSchemasRequest request) throws Exception {
        return this.doListSchemaNames(blockAllocator, request, null);
    }

    protected ListSchemasResponse doListSchemaNames(BlockAllocator blockAllocator, ListSchemasRequest request, DatabaseFilter filter) throws Exception {
        GetDatabasesResult result;
        GetDatabasesRequest getDatabasesRequest = new GetDatabasesRequest();
        getDatabasesRequest.setCatalogId(this.getCatalog(request));
        ArrayList<String> schemas = new ArrayList<String>();
        String nextToken = null;
        do {
            getDatabasesRequest.setNextToken(nextToken);
            result = this.awsGlue.getDatabases(getDatabasesRequest);
            for (Database next : result.getDatabaseList()) {
                if (filter != null && !filter.filter(next)) continue;
                schemas.add(next.getName());
            }
        } while ((nextToken = result.getNextToken()) != null);
        return new ListSchemasResponse(request.getCatalogName(), schemas);
    }

    @Override
    public ListTablesResponse doListTables(BlockAllocator blockAllocator, ListTablesRequest request) throws Exception {
        return this.doListTables(blockAllocator, request, null);
    }

    protected ListTablesResponse doListTables(BlockAllocator blockAllocator, ListTablesRequest request, TableFilter filter) throws Exception {
        GetTablesResult result;
        GetTablesRequest getTablesRequest = new GetTablesRequest();
        getTablesRequest.setCatalogId(this.getCatalog(request));
        getTablesRequest.setDatabaseName(request.getSchemaName());
        HashSet<TableName> tables = new HashSet<TableName>();
        String nextToken = request.getNextToken();
        int pageSize = request.getPageSize();
        do {
            getTablesRequest.setNextToken(nextToken);
            if (pageSize != -1) {
                int maxResults = Math.min(pageSize, 100);
                getTablesRequest.setMaxResults(Integer.valueOf(maxResults));
                pageSize -= maxResults;
            }
            result = this.awsGlue.getTables(getTablesRequest);
            for (Table next : result.getTableList()) {
                if (filter != null && !filter.filter(next)) continue;
                tables.add(new TableName(request.getSchemaName(), next.getName()));
            }
        } while ((nextToken = result.getNextToken()) != null && (pageSize == -1 || pageSize > 0));
        return new ListTablesResponse(request.getCatalogName(), tables, nextToken);
    }

    @Override
    public GetTableResponse doGetTable(BlockAllocator blockAllocator, com.amazonaws.athena.connector.lambda.metadata.GetTableRequest request) throws Exception {
        return this.doGetTable(blockAllocator, request, null);
    }

    private boolean isPreviouslyUnsupported(String glueType, Field arrowField) {
        boolean currentResult;
        boolean bl = currentResult = arrowField.getType().getTypeID().equals((Object)ArrowType.ArrowTypeID.Decimal) || arrowField.getType().getTypeID().equals((Object)ArrowType.ArrowTypeID.Map) || glueType.contains("set<");
        if (!currentResult) {
            for (Field child : arrowField.getChildren()) {
                if (!this.isPreviouslyUnsupported("", child)) continue;
                return true;
            }
        }
        return currentResult;
    }

    protected GetTableResponse doGetTable(BlockAllocator blockAllocator, com.amazonaws.athena.connector.lambda.metadata.GetTableRequest request, TableFilter filter) throws Exception {
        TableName tableName = request.getTableName();
        GetTableRequest getTableRequest = new GetTableRequest();
        getTableRequest.setCatalogId(this.getCatalog(request));
        getTableRequest.setDatabaseName(tableName.getSchemaName());
        getTableRequest.setName(tableName.getTableName());
        GetTableResult result = this.awsGlue.getTable(getTableRequest);
        Table table = result.getTable();
        if (filter != null && !filter.filter(table)) {
            throw new RuntimeException("No matching table found " + request.getTableName());
        }
        SchemaBuilder schemaBuilder = SchemaBuilder.newBuilder();
        if (table.getParameters() != null) {
            table.getParameters().entrySet().forEach(next -> schemaBuilder.addMetadata((String)next.getKey(), (String)next.getValue()));
        }
        Map<String, String> columnNameMapping = GlueMetadataHandler.getColumnNameMapping(table);
        Map<String, String> dateTimeFormatMapping = this.getDateTimeFormatMapping(table);
        HashMap<String, String> datetimeFormatMappingWithColumnName = new HashMap<String, String>();
        HashSet<String> partitionCols = new HashSet();
        if (table.getPartitionKeys() != null) {
            partitionCols = table.getPartitionKeys().stream().map(next -> columnNameMapping.getOrDefault(next.getName(), next.getName())).collect(Collectors.toSet());
        }
        List allColumns = Stream.of(table.getStorageDescriptor().getColumns(), table.getPartitionKeys() == null ? new ArrayList() : table.getPartitionKeys()).flatMap(x -> x.stream()).collect(Collectors.toList());
        boolean glueTableContainsPreviouslyUnsupportedType = false;
        for (Column next2 : allColumns) {
            String rawColumnName = next2.getName();
            String mappedColumnName = columnNameMapping.getOrDefault(rawColumnName, rawColumnName);
            logger.info("Column {} with registered type {}", (Object)rawColumnName, (Object)next2.getType());
            Field arrowField = this.convertField(mappedColumnName, next2.getType());
            schemaBuilder.addField(arrowField);
            if (next2.getComment() != null && !next2.getComment().trim().isEmpty()) {
                schemaBuilder.addMetadata(mappedColumnName, next2.getComment());
            }
            if (dateTimeFormatMapping.containsKey(rawColumnName)) {
                datetimeFormatMappingWithColumnName.put(mappedColumnName, dateTimeFormatMapping.get(rawColumnName));
            }
            if (glueTableContainsPreviouslyUnsupportedType || !this.isPreviouslyUnsupported(next2.getType(), arrowField)) continue;
            glueTableContainsPreviouslyUnsupportedType = true;
        }
        this.populateDatetimeFormatMappingIfAvailable(schemaBuilder, datetimeFormatMappingWithColumnName);
        GlueMetadataHandler.populateSourceTableNameIfAvailable(table, schemaBuilder);
        if (table.getViewOriginalText() != null && !table.getViewOriginalText().isEmpty()) {
            schemaBuilder.addMetadata(VIEW_METADATA_FIELD, table.getViewOriginalText());
        }
        schemaBuilder.addMetadata(GLUE_TABLE_CONTAINS_PREVIOUSLY_UNSUPPORTED_TYPE, String.valueOf(glueTableContainsPreviouslyUnsupportedType));
        return new GetTableResponse(request.getCatalogName(), request.getTableName(), schemaBuilder.build(), partitionCols);
    }

    protected Field convertField(String name, String glueType) {
        try {
            return GlueFieldLexer.lex(name, glueType);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Error converting field[" + name + "] with type[" + glueType + "]", ex);
        }
    }

    protected static void populateSourceTableNameIfAvailable(Table table, SchemaBuilder schemaBuilder) {
        Matcher matcher;
        String sourceTableProperty = (String)table.getParameters().get(SOURCE_TABLE_PROPERTY);
        if (sourceTableProperty != null) {
            return;
        }
        String location = table.getStorageDescriptor().getLocation();
        if (location != null && (matcher = TABLE_ARN_REGEX.matcher(location)).matches()) {
            schemaBuilder.addMetadata(SOURCE_TABLE_PROPERTY, matcher.group(1));
        }
    }

    protected static String getSourceTableName(Schema schema) {
        return (String)schema.getCustomMetadata().get(SOURCE_TABLE_PROPERTY);
    }

    protected static Map<String, String> getColumnNameMapping(Table table) {
        String columnNameMappingParam = (String)table.getParameters().get(COLUMN_NAME_MAPPING_PROPERTY);
        if (!Strings.isNullOrEmpty((String)columnNameMappingParam)) {
            return MAP_SPLITTER.split((CharSequence)columnNameMappingParam);
        }
        return ImmutableMap.of();
    }

    private Map<String, String> getDateTimeFormatMapping(Table table) {
        String datetimeFormatMappingParam = (String)table.getParameters().get(DATETIME_FORMAT_MAPPING_PROPERTY);
        if (!Strings.isNullOrEmpty((String)datetimeFormatMappingParam)) {
            return MAP_SPLITTER.split((CharSequence)datetimeFormatMappingParam);
        }
        return ImmutableMap.of();
    }

    private void populateDatetimeFormatMappingIfAvailable(SchemaBuilder schemaBuilder, Map<String, String> dateTimeFormatMapping) {
        if (dateTimeFormatMapping.size() > 0) {
            String datetimeFormatMappingString = dateTimeFormatMapping.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
            schemaBuilder.addMetadata(DATETIME_FORMAT_MAPPING_PROPERTY_NORMALIZED, datetimeFormatMappingString);
        }
    }

    private Optional<String> getFunctionOwner(String functionArn) {
        if (functionArn != null) {
            Pattern arnPattern = Pattern.compile(FUNCTION_ARN_REGEX);
            Matcher arnMatcher = arnPattern.matcher(functionArn);
            try {
                if (arnMatcher.matches() && arnMatcher.groupCount() > 0 && arnMatcher.group(1) != null) {
                    return Optional.of(arnMatcher.group(1));
                }
            }
            catch (Exception e) {
                logger.warn("Unable to parse owner from function arn: " + functionArn, (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public static interface DatabaseFilter {
        public boolean filter(Database var1);
    }

    public static interface TableFilter {
        public boolean filter(Table var1);
    }
}

