/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.handlers;

import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.ThrottlingInvoker;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockSpiller;
import com.amazonaws.athena.connector.lambda.data.SpillConfig;
import com.amazonaws.athena.connector.lambda.handlers.AthenaExceptionFilter;
import com.amazonaws.athena.connector.lambda.records.ReadRecordsRequest;
import com.amazonaws.athena.connector.lambda.records.RecordRequest;
import com.amazonaws.athena.connector.lambda.records.RecordRequestType;
import com.amazonaws.athena.connector.lambda.records.RecordResponse;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.request.PingRequest;
import com.amazonaws.athena.connector.lambda.request.PingResponse;
import com.amazonaws.athena.connector.lambda.security.CachableSecretsManager;
import com.amazonaws.athena.connector.lambda.serde.VersionedObjectMapperFactory;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.athena.AmazonAthenaClientBuilder;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecordHandler
implements RequestStreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(RecordHandler.class);
    private static final String MAX_BLOCK_SIZE_BYTES = "MAX_BLOCK_SIZE_BYTES";
    private static final int NUM_SPILL_THREADS = 2;
    protected final Map<String, String> configOptions;
    private final AmazonS3 amazonS3;
    private final String sourceType;
    private final CachableSecretsManager secretsManager;
    private final AmazonAthena athena;
    private final ThrottlingInvoker athenaInvoker;

    public RecordHandler(String sourceType, Map<String, String> configOptions) {
        this.sourceType = sourceType;
        this.amazonS3 = AmazonS3ClientBuilder.defaultClient();
        this.secretsManager = new CachableSecretsManager(AWSSecretsManagerClientBuilder.defaultClient());
        this.athena = AmazonAthenaClientBuilder.defaultClient();
        this.configOptions = configOptions;
        this.athenaInvoker = ThrottlingInvoker.newDefaultBuilder(AthenaExceptionFilter.ATHENA_EXCEPTION_FILTER, configOptions).build();
    }

    public RecordHandler(AmazonS3 amazonS3, AWSSecretsManager secretsManager, AmazonAthena athena, String sourceType, Map<String, String> configOptions) {
        this.sourceType = sourceType;
        this.amazonS3 = amazonS3;
        this.secretsManager = new CachableSecretsManager(secretsManager);
        this.athena = athena;
        this.configOptions = configOptions;
        this.athenaInvoker = ThrottlingInvoker.newDefaultBuilder(AthenaExceptionFilter.ATHENA_EXCEPTION_FILTER, configOptions).build();
    }

    protected String resolveSecrets(String rawString) {
        return this.secretsManager.resolveSecrets(rawString);
    }

    protected String getSecret(String secretName) {
        return this.secretsManager.getSecret(secretName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        try (BlockAllocatorImpl allocator = new BlockAllocatorImpl();){
            ObjectMapper objectMapper = VersionedObjectMapperFactory.create(allocator);
            try {
                FederationRequest rawReq;
                block24: {
                    rawReq = (FederationRequest)objectMapper.readValue(inputStream, FederationRequest.class);
                    if (!(rawReq instanceof PingRequest)) break block24;
                    try (PingResponse response = this.doPing((PingRequest)rawReq);){
                        this.assertNotNull(response);
                        objectMapper.writeValue(outputStream, (Object)response);
                    }
                    if (rawReq == null) return;
                    rawReq.close();
                    return;
                }
                try {
                    if (!(rawReq instanceof RecordRequest)) {
                        throw new RuntimeException("Expected a RecordRequest but found " + rawReq.getClass());
                    }
                    this.doHandleRequest(allocator, objectMapper, (RecordRequest)rawReq, outputStream);
                    return;
                }
                finally {
                    if (rawReq != null) {
                        rawReq.close();
                    }
                }
            }
            catch (Exception ex) {
                RuntimeException runtimeException;
                logger.warn("handleRequest: Completed with an exception.", (Throwable)ex);
                if (ex instanceof RuntimeException) {
                    runtimeException = (RuntimeException)ex;
                    throw runtimeException;
                }
                runtimeException = new RuntimeException(ex);
                throw runtimeException;
            }
        }
    }

    protected final void doHandleRequest(BlockAllocator allocator, ObjectMapper objectMapper, RecordRequest req, OutputStream outputStream) throws Exception {
        logger.info("doHandleRequest: request[{}]", (Object)req);
        RecordRequestType type = req.getRequestType();
        switch (type) {
            case READ_RECORDS: {
                try (RecordResponse response = this.doReadRecords(allocator, (ReadRecordsRequest)req);){
                    logger.info("doHandleRequest: response[{}]", (Object)response);
                    this.assertNotNull(response);
                    objectMapper.writeValue(outputStream, (Object)response);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown request type " + (Object)((Object)type));
    }

    /*
     * Exception decompiling
     */
    public RecordResponse doReadRecords(BlockAllocator allocator, ReadRecordsRequest request) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract void readWithConstraint(BlockSpiller var1, ReadRecordsRequest var2, QueryStatusChecker var3) throws Exception;

    protected SpillConfig getSpillConfig(ReadRecordsRequest request) {
        long maxBlockSize = request.getMaxBlockSize();
        if (this.configOptions.get(MAX_BLOCK_SIZE_BYTES) != null) {
            maxBlockSize = Long.parseLong(this.configOptions.get(MAX_BLOCK_SIZE_BYTES));
        }
        return SpillConfig.newBuilder().withSpillLocation(request.getSplit().getSpillLocation()).withMaxBlockBytes(maxBlockSize).withMaxInlineBlockBytes(request.getMaxInlineBlockSize()).withRequestId(request.getQueryId()).withEncryptionKey(request.getSplit().getEncryptionKey()).withNumSpillThreads(2).build();
    }

    private PingResponse doPing(PingRequest request) {
        PingResponse response = new PingResponse(request.getCatalogName(), request.getQueryId(), this.sourceType, 24, 4);
        try {
            this.onPing(request);
        }
        catch (Exception ex) {
            logger.warn("doPing: encountered an exception while delegating onPing.", (Throwable)ex);
        }
        return response;
    }

    protected void onPing(PingRequest request) {
    }

    private void assertNotNull(FederationResponse response) {
        if (response == null) {
            throw new RuntimeException("Response was null");
        }
    }
}

