/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata;

import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.metadata.MetadataResponse;
import com.amazonaws.athena.connector.lambda.metadata.optimizations.OptimizationSubType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetDataSourceCapabilitiesResponse
extends MetadataResponse {
    private final Map<String, List<OptimizationSubType>> capabilities;

    public GetDataSourceCapabilitiesResponse(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="capabilities") Map<String, List<OptimizationSubType>> capabilities) {
        super(MetadataRequestType.GET_DATASOURCE_CAPABILITIES, catalogName);
        Objects.requireNonNull(capabilities, "capabilities are null");
        this.capabilities = Collections.unmodifiableMap(capabilities);
    }

    public Map<String, List<OptimizationSubType>> getCapabilities() {
        return Collections.unmodifiableMap(this.capabilities);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("capabilities", this.capabilities).add("requestType", (Object)this.getRequestType()).add("catalogName", (Object)this.getCatalogName()).toString();
    }

    @Override
    public void close() throws Exception {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDataSourceCapabilitiesResponse that = (GetDataSourceCapabilitiesResponse)o;
        return com.google.common.base.Objects.equal(this.capabilities, that.capabilities) && com.google.common.base.Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && com.google.common.base.Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.capabilities, this.getRequestType(), this.getCatalogName()});
    }
}

